/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.text;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.text.TextBlockAttributeListNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.util.TextUtil;
import java.util.Collections;
import java.util.List;

public class NotationAttributeNode
extends DALNode {
    private final TextBlockAttributeListNode attributeList;
    private final DALNode notation;

    public NotationAttributeNode(DALNode notation, TextBlockAttributeListNode attributeList) {
        this.notation = notation;
        this.attributeList = attributeList;
    }

    @Override
    public String inspect() {
        return (this.notation.inspect() + " " + this.attributeList.inspect()).trim();
    }

    public String endNotation() {
        return this.notation.inspect();
    }

    public Object text(List<Character> content, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.attributeList.getAttribute(context).format(TextUtil.join(content).substring(this.notation.getIndent()).replace("\n" + String.join((CharSequence)"", Collections.nCopies(this.notation.getIndent(), " ")), "\n"));
    }
}

