/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Checker;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ExpectActual;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ConditionalChecker
extends Checker {
    public static final Checker MATCH_NULL_CHECKER = ConditionalChecker.conditionalChecker(ExpectActual::actualNotNull, ExpectActual::notationMatch);
    public static final Checker MATCH_NUMBER_CHECKER = ConditionalChecker.conditionalChecker(ExpectActual::numberNotEquals, ExpectActual::notationNumberMatch);
    public static final Checker EQUALS_CHECKER = ConditionalChecker.conditionalChecker(ExpectActual::objectNotEquals, ExpectActual::notationEqualTo);
    public static final Checker MATCH_CHECKER = ConditionalChecker.matchTypeChecker(String.class, Number.class).and(ConditionalChecker.matchTypeChecker(String.class, Boolean.class)).and(ConditionalChecker.matchTypeChecker(Number.class, String.class)).and(ConditionalChecker.matchTypeChecker(Boolean.class, String.class)).and(new ConvertMatchChecker());

    public static ConditionalChecker matchTypeChecker(Class<?> actualType, Class<?> expectType) {
        return ConditionalChecker.conditionalChecker(expectActual -> expectActual.isInstanceOf(actualType, expectType), ExpectActual::cannotCompare);
    }

    public static ConditionalChecker conditionalChecker(final Predicate<ExpectActual> failed, final Function<ExpectActual, String> message) {
        return new ConditionalChecker(){

            @Override
            public String message(ExpectActual expectActual) {
                return (String)message.apply(expectActual);
            }

            @Override
            public boolean failed(ExpectActual expectActual) {
                return failed.test(expectActual);
            }
        };
    }

    public boolean failed(ExpectActual var1);

    public String message(ExpectActual var1);

    @Override
    default public boolean verify(ExpectActual expectActual, int position) {
        if (this.failed(expectActual)) {
            throw new AssertionFailure(this.message(expectActual), position);
        }
        return true;
    }

    public static class ConvertMatchChecker
    implements ConditionalChecker {
        private String message;

        @Override
        public boolean failed(ExpectActual expectActual) {
            try {
                Data result = expectActual.convertToExpectedType();
                if (expectActual.equalTo(result)) {
                    return false;
                }
                this.message = expectActual.notationMatch(result);
            }
            catch (Exception e) {
                this.message = e.getMessage();
            }
            return true;
        }

        @Override
        public String message(ExpectActual expectActual1) {
            return this.message;
        }
    }
}

