/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.InvalidPropertyException;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.NoSuchAccessorException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class JavaClassPropertyAccessor<T>
implements PropertyAccessor<T> {
    private final BeanClass<T> beanClass;

    public JavaClassPropertyAccessor(BeanClass<T> type) {
        this.beanClass = type;
    }

    @Override
    public Object getValue(T instance, Object property) {
        try {
            return this.beanClass.getPropertyValue(instance, (String)property);
        }
        catch (NoSuchAccessorException ignore) {
            throw new InvalidPropertyException(String.format("Method or property `%s` does not exist in `%s`", property, instance.getClass().getName()));
        }
    }

    @Override
    public Set<Object> getPropertyNames(T instance) {
        return new LinkedHashSet<Object>(this.beanClass.getPropertyReaders().keySet());
    }

    @Override
    public boolean isNull(T instance) {
        return Objects.equals(instance, null);
    }
}

