/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.CacheableInspector;
import com.github.leeonky.dal.runtime.inspector.InspectorCache;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.util.Classes;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListInspector
extends CacheableInspector {
    public ListInspector(Data data) {
        super(data);
    }

    @Override
    public String cachedInspect(String path, InspectorCache cache) {
        List<Data> dataList = this.data.getDataList();
        String type = this.type();
        if (dataList.isEmpty()) {
            return type + "[]";
        }
        AtomicInteger index = new AtomicInteger(0);
        return type + dataList.stream().map(data -> data.buildInspector().dump(path + "[" + index.getAndIncrement() + "]", cache)).map(TextUtil::indent).collect(Collectors.joining(",\n", "[\n", "\n]"));
    }

    protected String type() {
        if (this.data.getInstance() instanceof Iterable || this.data.getInstance() instanceof Stream || this.data.getInstance().getClass().isArray()) {
            return "";
        }
        return Classes.getClassName((Object)this.data.getInstance()) + " ";
    }
}

