/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.interpreter.Notation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Notations {
    public static final Notation<DALNode, DALOperator, DALProcedure> SINGLE_QUOTED = Notation.notation((String)"'");
    public static final Notation<DALNode, DALOperator, DALProcedure> DOUBLE_QUOTED = Notation.notation((String)"\"");
    public static final Notation<DALNode, DALOperator, DALProcedure> OPENING_BRACKET = Notation.notation((String)"[");
    public static final Notation<DALNode, DALOperator, DALProcedure> CLOSING_BRACKET = Notation.notation((String)"]");
    public static final Notation<DALNode, DALOperator, DALProcedure> OPENING_PARENTHESES = Notation.notation((String)"(");
    public static final Notation<DALNode, DALOperator, DALProcedure> CLOSING_PARENTHESES = Notation.notation((String)")");
    public static final Notation<DALNode, DALOperator, DALProcedure> SCHEMA_AND = Notation.notation((String)"/");
    public static final Notation<DALNode, DALOperator, DALProcedure> OPEN_REGEX = Notation.notation((String)"/");
    public static final Notation<DALNode, DALOperator, DALProcedure> CLOSE_REGEX = Notation.notation((String)"/");
    public static final Notation<DALNode, DALOperator, DALProcedure> OPENING_BRACES = Notation.notation((String)"{");
    public static final Notation<DALNode, DALOperator, DALProcedure> CLOSING_BRACES = Notation.notation((String)"}");
    public static final Notation<DALNode, DALOperator, DALProcedure> COMMA = Notation.notation((String)",");
    public static final Notation<DALNode, DALOperator, DALProcedure> COLUMN_SPLITTER = Notation.notation((String)"|");
    public static final Notation<DALNode, DALOperator, DALProcedure> MATRIX_COLUMN_SPLITTER = Notation.notation((String)"^");
    public static final Notation<DALNode, DALOperator, DALProcedure> SEQUENCE_AZ = Notation.notation((String)"+");
    public static final Notation<DALNode, DALOperator, DALProcedure> SEQUENCE_ZA = Notation.notation((String)"-");
    public static final Notation<DALNode, DALOperator, DALProcedure> SEQUENCE_AZ_2 = Notation.notation((String)"\uffea");
    public static final Notation<DALNode, DALOperator, DALProcedure> SEQUENCE_ZA_2 = Notation.notation((String)"\uffec");
    public static final Notation<DALNode, DALOperator, DALProcedure> TRANSPOSE_MARK = Notation.notation((String)">>");
    public static final Notation<DALNode, DALOperator, DALProcedure> LINE_COMMENT1 = Notation.notation((String)"#");
    public static final Notation<DALNode, DALOperator, DALProcedure> LINE_COMMENT2 = Notation.notation((String)"//");
    public static final Notation<DALNode, DALOperator, DALProcedure> LIST_MAPPING = Notation.notation((String)"[]");
    public static final Notation<DALNode, DALOperator, DALProcedure> OPENING_GROUP = Notation.notation((String)"<<");
    public static final Notation<DALNode, DALOperator, DALProcedure> CLOSING_GROUP = Notation.notation((String)">>");
    public static final Notation<DALNode, DALOperator, DALProcedure> TEXT_BLOCK = Notation.notation((String)"`");
    public static final Notation<DALNode, DALOperator, DALProcedure> EMPTY = Notation.notation((String)"");
    public static final Notation<DALNode, DALOperator, DALProcedure> THIS = Notation.notation((String)"{}");
    public static final List<Notation<?, ?, ?>> LINE_COMMENTS = Arrays.asList(LINE_COMMENT1, LINE_COMMENT2);

    public static class Operators {
        public static final Notation<DALNode, DALOperator, DALProcedure> WILDCARD = Notation.notation((String)"*");
        public static final Notation<DALNode, DALOperator, DALProcedure> ROW_WILDCARD = Notation.notation((String)"***");
        public static final Notation<DALNode, DALOperator, DALProcedure> ELEMENT_ELLIPSIS = Notation.notation((String)"...");
        public static final Notation<DALNode, DALOperator, DALProcedure> AND = Notation.notation((String)"&&");
        public static final Notation<DALNode, DALOperator, DALProcedure> OR = Notation.notation((String)"||");
        public static final Notation<DALNode, DALOperator, DALProcedure> COMMA = Notation.notation((String)",");
        public static final Notation<DALNode, DALOperator, DALProcedure> GREATER_OR_EQUAL = Notation.notation((String)">=");
        public static final Notation<DALNode, DALOperator, DALProcedure> LESS_OR_EQUAL = Notation.notation((String)"<=");
        public static final Notation<DALNode, DALOperator, DALProcedure> GREATER = Notation.notation((String)">");
        public static final Notation<DALNode, DALOperator, DALProcedure> LESS = Notation.notation((String)"<");
        public static final Notation<DALNode, DALOperator, DALProcedure> PLUS = Notation.notation((String)"+");
        public static final Notation<DALNode, DALOperator, DALProcedure> SUBTRACTION = Notation.notation((String)"-");
        public static final Notation<DALNode, DALOperator, DALProcedure> MULTIPLICATION = Notation.notation((String)"*");
        public static final Notation<DALNode, DALOperator, DALProcedure> DIVISION = Notation.notation((String)"/");
        public static final Notation<DALNode, DALOperator, DALProcedure> NOT_EQUAL = Notation.notation((String)"!=");
        public static final Notation<DALNode, DALOperator, DALProcedure> MINUS = Notation.notation((String)"-");
        public static final Notation<DALNode, DALOperator, DALProcedure> NOT = Notation.notation((String)"!");
        public static final Notation<DALNode, DALOperator, DALProcedure> MATCHER = Notation.notation((String)":");
        public static final Notation<DALNode, DALOperator, DALProcedure> EQUAL = Notation.notation((String)"=");
        public static final Notation<DALNode, DALOperator, DALProcedure> DOT = Notation.notation((String)".");
        public static final Notation<DALNode, DALOperator, DALProcedure> SLASH = Notation.notation((String)"/");
        public static final Notation<DALNode, DALOperator, DALProcedure> META = Notation.notation((String)"::");
        public static final Notation<DALNode, DALOperator, DALProcedure> IS = Keywords.IS;
        public static final Notation<DALNode, DALOperator, DALProcedure> WHICH = Keywords.WHICH;
    }

    public static class Keywords {
        public static final Notation<DALNode, DALOperator, DALProcedure> WHICH = Notation.notation((String)"which");
        public static final Notation<DALNode, DALOperator, DALProcedure> IS = Notation.notation((String)"is");
        public static final Notation<DALNode, DALOperator, DALProcedure> TRUE = Notation.notation((String)"true");
        public static final Notation<DALNode, DALOperator, DALProcedure> FALSE = Notation.notation((String)"false");
        public static final Notation<DALNode, DALOperator, DALProcedure> NULL = Notation.notation((String)"null");
        public static final Notation<DALNode, DALOperator, DALProcedure> AND = Notation.notation((String)"and");
        public static final Notation<DALNode, DALOperator, DALProcedure> OR = Notation.notation((String)"or");
        public static final Set<Notation<DALNode, DALOperator, DALProcedure>> ALL = new HashSet<Notation>(Arrays.asList(WHICH, IS, TRUE, FALSE, NULL, AND, OR));
        public static final Set<String> ALL_STRING = ALL.stream().map(Notation::getLabel).collect(Collectors.toSet());
    }
}

