/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.runtime.AutoMappingList;
import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.CurryingMethodGroup;
import com.github.leeonky.dal.runtime.InstanceCurryingMethod;
import com.github.leeonky.dal.runtime.PartialObject;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.inspector.DumpingBuffer;
import com.github.leeonky.util.Classes;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Data {
    private final SchemaType schemaType;
    private final RuntimeContextBuilder.DALRuntimeContext context;
    private final Object instance;
    private List<Object> listValue;
    private Comparator<Object> listComparator = SortGroupNode.NOP_COMPARATOR;

    public Data(Object instance, RuntimeContextBuilder.DALRuntimeContext context, SchemaType schemaType) {
        this.instance = instance;
        this.schemaType = schemaType;
        this.context = context.registerPropertyAccessor(instance);
    }

    public Object getInstance() {
        return this.instance;
    }

    public Set<Object> getFieldNames() {
        return this.context.findPropertyReaderNames(this.instance);
    }

    public boolean isList() {
        return this.context.isRegisteredList(this.instance) || this.instance != null && this.instance.getClass().isArray();
    }

    public int getListSize() {
        return this.getValueList().size();
    }

    public List<Object> getValueList() {
        return this.listValue == null ? (this.listValue = StreamSupport.stream(this.context.getList(this.instance).spliterator(), false).sorted(this.listComparator).collect(Collectors.toList())) : this.listValue;
    }

    public List<Data> getDataList() {
        AtomicInteger index = new AtomicInteger(0);
        return this.getValueList().stream().map(object -> new Data(object, this.context, this.schemaType.access(index.incrementAndGet()))).collect(Collectors.toList());
    }

    public boolean isNull() {
        return this.context.isNull(this.instance);
    }

    public Data getValue(List<Object> propertyChain) {
        return propertyChain.isEmpty() ? this : this.getValue(propertyChain.get(0)).getValue(propertyChain.subList(1, propertyChain.size()));
    }

    public Data getValue(Object propertyChain) {
        try {
            List<Object> chain = this.schemaType.access(propertyChain).getPropertyChainBefore(this.schemaType);
            if (chain.size() == 1 && chain.get(0).equals(propertyChain)) {
                return new Data(this.getPropertyValue(propertyChain), this.context, this.propertySchema(propertyChain));
            }
            return this.getValue(chain);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new PropertyAccessException(String.format("Index out of bounds (%s), first index is: %d", ex.getMessage(), this.getListFirstIndex()), ex);
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format("Get property `%s` failed, property can be:\n  1. public field\n  2. public getter\n  3. public no args method\n  4. Map key value\n  5. customized type getter\n  6. static method extension\n%s%s", propertyChain, e.getMessage(), this.listMappingMessage(this, propertyChain)), e);
        }
    }

    private String listMappingMessage(Data data, Object symbol) {
        return data.isList() ? String.format("\nImplicit list mapping is not allowed in current version of DAL, use `%s[]` instead", symbol) : "";
    }

    private Object getPropertyValue(Object property) {
        return this.isList() ? this.fetchFromList(property) : this.context.getPropertyValue(this, property);
    }

    private Object fetchFromList(Object property) {
        if (property instanceof String) {
            return this.context.getPropertyValue(this, property);
        }
        if ((Integer)property < 0) {
            return this.getValueList().get(this.getListSize() + (Integer)property);
        }
        return this.getValueList().get((Integer)property - this.getListFirstIndex());
    }

    public int getListFirstIndex() {
        return this.context.getListFirstIndex(this.instance);
    }

    private SchemaType propertySchema(Object property) {
        if (this.isList() && property instanceof String) {
            return this.schemaType.mappingAccess(property);
        }
        return this.schemaType.access(property);
    }

    public Object firstFieldFromAlias(Object alias) {
        return this.schemaType.firstFieldFromAlias(alias);
    }

    public Data convert(Class<?> target) {
        return new Data(this.context.getConverter().convert(target, this.instance), this.context, this.schemaType);
    }

    public Data setListComparator(Comparator<Object> listComparator) {
        this.listComparator = listComparator;
        return this;
    }

    public Data listMap(Object property) {
        return new Data(this.listMap((Data data) -> data.getValue(property).getInstance()), this.context, this.propertySchema(property));
    }

    public AutoMappingList listMap(Function<Data, Object> mapper) {
        return new AutoMappingList(this.getListFirstIndex(), this.getDataList(), mapper);
    }

    public Data filter(String prefix) {
        FilteredObject filteredObject = new FilteredObject();
        this.getFieldNames().stream().filter(String.class::isInstance).map(String.class::cast).filter((? super T field) -> field.startsWith(prefix)).forEach(fieldName -> filteredObject.put(this.trimPrefix(prefix, (String)fieldName), this.getValue(fieldName).getInstance()));
        return new Data(filteredObject, this.context, this.schemaType).setListComparator(this.listComparator);
    }

    private String trimPrefix(String prefix, String fieldName) {
        return fieldName.substring(prefix.length(), prefix.length() + 1).toLowerCase() + fieldName.substring(prefix.length() + 1);
    }

    public String dumpAll() {
        return DumpingBuffer.rootContext(this.context).dump(this).content();
    }

    public String dumpValue() {
        return DumpingBuffer.rootContext(this.context).dumpValue(this).content();
    }

    public <T> T newBlockScope(Supplier<T> supplier) {
        return this.context.newBlockScope(this, supplier);
    }

    public Optional<CurryingMethod> currying(Object property) {
        return this.currying(this.instance, property);
    }

    private Optional<CurryingMethod> currying(Object instance, Object property) {
        List<InstanceCurryingMethod> methods = this.context.methodToCurrying(Classes.named(instance.getClass()), property).stream().map(method -> CurryingMethod.createCurryingMethod(instance, method, this.context.getConverter())).collect(Collectors.toList());
        if (!methods.isEmpty()) {
            return Optional.of(new CurryingMethodGroup(methods, null));
        }
        return this.context.getImplicitObject(instance).flatMap(obj -> this.currying(obj, property));
    }

    public Data requireList(int position) {
        if (this.isList()) {
            return this;
        }
        throw new RuntimeException(String.format("Invalid input value, expect a List but: %s", this.dumpAll().trim()), position);
    }

    static class FilteredObject
    extends LinkedHashMap<String, Object>
    implements PartialObject {
        FilteredObject() {
        }
    }
}

