/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.StaticCurryingMethod;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.Suppressor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class CurryingMethod {
    protected final Object instance;
    private final Method method;
    private final List<Object> args = new ArrayList<Object>();

    protected CurryingMethod(Object instance, Method method) {
        this.method = method;
        this.instance = instance;
    }

    public static CurryingMethod createCurryingMethod(Object instance, Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return new StaticCurryingMethod(instance, method);
        }
        return new CurryingMethod(instance, method);
    }

    public CurryingMethod call(Object arg, Converter converter) {
        CurryingMethod curryingMethod = CurryingMethod.createCurryingMethod(this.instance, this.method);
        curryingMethod.args.addAll(this.args);
        curryingMethod.args.add(converter.tryConvert(this.method.getParameters()[this.args().size()].getType(), arg));
        return curryingMethod;
    }

    private String parameterInfo() {
        List parameters = Arrays.stream(this.method.getParameters()).map(Parameter::toString).collect(Collectors.toList());
        int argPosition = this.args().size();
        if (parameters.size() > 0) {
            parameters.set(argPosition, "> " + (String)parameters.get(argPosition));
        }
        return parameters.stream().collect(Collectors.joining(",\n", String.format("%s.%s(\n", this.method.getDeclaringClass().getName(), this.method.getName()), "\n)"));
    }

    public Object resolve() {
        List<Object> args = this.args();
        return args.size() == this.method.getParameterCount() ? Suppressor.get(() -> this.method.invoke(this.instance, args.toArray())) : this;
    }

    protected List<Object> args() {
        return this.args;
    }

    public Set<Object> fetchArgRange(RuntimeContextBuilder runtimeContextBuilder) {
        BiFunction<Object, List<Object>, List<Object>> rangeFactory = runtimeContextBuilder.fetchCurryingMethodArgRange(this.method);
        if (rangeFactory != null) {
            return new LinkedHashSet<Object>((Collection)rangeFactory.apply(this.instance, this.args));
        }
        System.err.printf("No arg range for %s, give the range or use `:`%n", this.parameterInfo());
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("instance: %s\nmethod: %s\nargs: %s", this.instance, this.method, this.args);
    }
}

