/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DALFactory;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.compiler.Compiler;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Extension;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.util.TextUtil;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.Classes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DAL {
    private final Compiler compiler = new Compiler();
    private final RuntimeContextBuilder runtimeContextBuilder = new RuntimeContextBuilder();
    private static final ThreadLocal<DAL> instance = new ThreadLocal();

    public static synchronized DAL getInstance() {
        if (instance.get() == null) {
            instance.set(DAL.create(new Class[0]));
        }
        return instance.get();
    }

    public static DAL create(Class<?> ... exceptExtensions) {
        Iterator<DALFactory> iterator = ServiceLoader.load(DALFactory.class).iterator();
        if (iterator.hasNext()) {
            return iterator.next().newInstance();
        }
        return new DAL().extend(exceptExtensions);
    }

    public RuntimeContextBuilder getRuntimeContextBuilder() {
        return this.runtimeContextBuilder;
    }

    public <T> List<T> evaluateAll(Object input, String expressions) {
        RuntimeContextBuilder.DALRuntimeContext runtimeContext = this.runtimeContextBuilder.build(input);
        return this.compiler.compile(new SourceCode(this.format(expressions), Notations.LINE_COMMENTS), runtimeContext).stream().map(node -> node.evaluate(runtimeContext)).collect(Collectors.toList());
    }

    public <T> T evaluate(Object input, String expression) {
        RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2 = this.runtimeContextBuilder.build(input);
        List<DALNode> nodes = this.compiler.compile(new SourceCode(this.format(expression), Notations.LINE_COMMENTS), DALRuntimeContext2);
        if (nodes.size() > 1) {
            throw new SyntaxException("more than one expression", this.getOperandPosition(nodes.get(1)));
        }
        return (T)nodes.get(0).evaluate(DALRuntimeContext2);
    }

    private int getOperandPosition(DALNode node) {
        return node.getPositionBegin() == 0 ? node.getOperandPosition() : node.getPositionBegin();
    }

    private String format(String expression) {
        return String.join((CharSequence)"\n", TextUtil.lines(expression));
    }

    public DAL extend(Class<?> ... excepts) {
        HashSet exceptExtensions = new HashSet(Arrays.asList(excepts));
        Stream.concat(Classes.subTypesOf(Extension.class, (String)"com.github.leeonky.dal.extensions").stream(), Classes.subTypesOf(Extension.class, (String)"com.github.leeonky.extensions.dal").stream()).filter(com.github.leeonky.util.function.Extension.not(exceptExtensions::contains)).map(x$0 -> (Extension)Classes.newInstance((Class)x$0, (Object[])new Object[0])).sorted(Comparator.comparing(Extension::order)).forEach(e -> e.extend(this));
        return this;
    }
}

