/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.checker.Checker;
import com.github.leeonky.dal.runtime.checker.CheckingContext;
import com.github.leeonky.interpreter.NodeBase;
import com.github.leeonky.util.function.TriFunction;
import java.util.List;
import java.util.stream.Stream;

public abstract class DALNode
extends NodeBase<RuntimeContextBuilder.DALRuntimeContext, DALNode> {
    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(this.evaluate(context));
    }

    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.evaluateData(context).getInstance();
    }

    public boolean verify(DALNode actualNode, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode, context, (TriFunction<RuntimeContextBuilder.DALRuntimeContext, Data, Data, Checker>)((TriFunction)RuntimeContextBuilder.DALRuntimeContext::fetchEqualsChecker));
    }

    public boolean verify(DALNode actualNode, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode, context, (TriFunction<RuntimeContextBuilder.DALRuntimeContext, Data, Data, Checker>)((TriFunction)RuntimeContextBuilder.DALRuntimeContext::fetchMatchingChecker));
    }

    private boolean verify(DALNode actualNode, RuntimeContextBuilder.DALRuntimeContext context, TriFunction<RuntimeContextBuilder.DALRuntimeContext, Data, Data, Checker> factory) {
        Data expected = this.evaluateData(context);
        expected.isNullWithPosition(this.getOperandPosition());
        Data actual = actualNode.evaluateData(context);
        actual.isNullWithPosition(actualNode.getOperandPosition());
        Checker checker = (Checker)factory.apply((Object)context, (Object)expected, (Object)actual);
        return checker.verify(this.createContext(context, expected, actual, checker));
    }

    private CheckingContext createContext(RuntimeContextBuilder.DALRuntimeContext context, Data expected, Data actual, Checker checker) {
        Data transformedActual;
        try {
            transformedActual = checker.transformActual(actual, expected, context);
        }
        catch (Exception ex) {
            throw new AssertionFailure(ex.getMessage(), this.getPositionBegin());
        }
        return new CheckingContext(expected, actual, checker.transformExpected(expected, context), transformedActual, this.getPositionBegin());
    }

    public abstract String inspect();

    public Object getRootSymbolName() {
        return null;
    }

    public List<Object> propertyChain() {
        throw new IllegalStateException();
    }

    public Stream<Object> collectFields(Data data) {
        return Stream.of(data.firstFieldFromAlias(this.getRootSymbolName()));
    }
}

