/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.PartialObject;
import com.github.leeonky.dal.runtime.PropertyAccessException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import java.util.Collections;
import java.util.List;

public class SymbolNode
extends DALNode
implements ExecutableNode {
    private final Object symbol;
    private final Type type;

    public SymbolNode(Object symbol, Type type) {
        this.symbol = symbol;
        this.type = type;
    }

    @Override
    public String inspect() {
        return this.type.inspect(this.symbol);
    }

    @Override
    public Data getValue(Data data, RuntimeContextBuilder.DALRuntimeContext context) {
        try {
            Data value;
            if (data.getInstance() instanceof PartialObject) {
                context.appendPartialPropertyReference(data, this.symbol);
            }
            if ((value = data.getValue(this.symbol)).getInstance() instanceof PartialObject) {
                context.initPartialPropertyStack(data, this.symbol, value);
            }
            return value;
        }
        catch (PropertyAccessException e) {
            throw e.toDalError("", this.getPositionBegin());
        }
    }

    @Override
    public List<Object> propertyChain() {
        return Collections.singletonList(this.symbol);
    }

    @Override
    public Object getRootSymbolName() {
        return this.symbol;
    }

    public static enum Type {
        SYMBOL,
        NUMBER,
        BRACKET{

            @Override
            public String inspect(Object symbol) {
                return symbol instanceof String ? String.format("['%s']", symbol) : String.format("[%s]", symbol);
            }
        }
        ,
        STRING{

            @Override
            public String inspect(Object symbol) {
                return String.format("'%s'", symbol);
            }
        };


        public String inspect(Object symbol) {
            return symbol.toString();
        }
    }
}

