/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.inspector.DumpingCacheKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DumpingBuffer {
    private final String path;
    private final int indent;
    private final LineBuffer lineBuffer;
    private StringBuilder splits;
    private int length = 0;
    private final RuntimeContextBuilder.DALRuntimeContext runtimeContext;

    private DumpingBuffer(String path, int indent, StringBuilder splits, LineBuffer buffer, RuntimeContextBuilder.DALRuntimeContext context) {
        this.path = path;
        this.lineBuffer = buffer;
        this.runtimeContext = context;
        this.indent = indent;
        this.splits = splits;
    }

    public static DumpingBuffer rootContext(RuntimeContextBuilder.DALRuntimeContext context) {
        return new DumpingBuffer("root", 0, new StringBuilder(), new LineBuffer(context), context);
    }

    public String getPath() {
        return this.path;
    }

    public RuntimeContextBuilder.DALRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public DumpingBuffer dump(Data data) {
        try {
            this.runtimeContext.fetchDumper(data).dump(data, this);
        }
        catch (Exception e) {
            this.append("*dump throw* " + e);
        }
        return this;
    }

    public DumpingBuffer dumpValue(Data data) {
        try {
            this.runtimeContext.fetchDumper(data).dumpValue(data, this);
        }
        catch (Exception e) {
            this.append("*dump throw* " + e);
        }
        return this;
    }

    public DumpingBuffer index(int index) {
        return this.createSub(String.format("%s[%d]", this.path, index), 0);
    }

    public DumpingBuffer sub(Object property) {
        return this.createSub(String.format("%s.%s", this.path, property), 0);
    }

    public DumpingBuffer indent() {
        return this.createSub(this.path, 1);
    }

    public DumpingBuffer sub() {
        return this.createSub(this.path, 0);
    }

    private DumpingBuffer createSub(String subPath, int indent) {
        return new DumpingBuffer(subPath, this.indent + indent, this.takeSplits(), this.lineBuffer, this.runtimeContext);
    }

    private StringBuilder takeSplits() {
        StringBuilder temp = this.splits;
        this.splits = new StringBuilder();
        return temp;
    }

    public void cached(Data data, Runnable runnable) {
        this.lineBuffer.cached(this.path, data, runnable, p -> this.append("*reference* " + p));
    }

    public DumpingBuffer append(String s) {
        this.length = this.lineBuffer.append(this.takeSplits(), s).length();
        return this;
    }

    public String content() {
        return this.lineBuffer.toString();
    }

    public DumpingBuffer appendThen(String then) {
        this.splits.append(then);
        return this;
    }

    public DumpingBuffer newLine() {
        this.appendThen("\n" + String.join((CharSequence)"", Collections.nCopies(this.indent, "    ")));
        return this;
    }

    public DumpingBuffer optionalNewLine() {
        if (this.length != this.lineBuffer.length()) {
            this.newLine();
        }
        return this;
    }

    public static class LineBuffer {
        private final Map<DumpingCacheKey, String> caches = new HashMap<DumpingCacheKey, String>();
        private final RuntimeContextBuilder.DALRuntimeContext runtimeContext;
        private final StringBuilder stringBuilder = new StringBuilder();
        private int lineCount = 0;
        private boolean finished = false;

        public LineBuffer(RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
        }

        public void cached(String path, Data data, Runnable dumpAction, Consumer<String> refAction) {
            DumpingCacheKey key = new DumpingCacheKey(data);
            String reference = this.caches.get(key);
            if (reference == null) {
                this.caches.put(key, path);
                dumpAction.run();
            } else {
                refAction.accept(reference);
            }
        }

        public int length() {
            return this.stringBuilder.length();
        }

        public String toString() {
            return this.stringBuilder.toString();
        }

        public LineBuffer append(StringBuilder splits, String content) {
            if (!this.finished) {
                if (splits.length() != 0) {
                    this.lineCount = (int)((long)this.lineCount + splits.chars().filter(c -> c == 10).count());
                    if (this.lineCount >= this.runtimeContext.maxDumpingLineCount()) {
                        this.stringBuilder.append("\n...");
                        this.finished = true;
                        return this;
                    }
                    this.stringBuilder.append((CharSequence)splits);
                }
                this.stringBuilder.append(content);
            }
            return this;
        }
    }
}

