/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.schema;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.format.Type;
import com.github.leeonky.dal.format.Value;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.schema.Actual;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.AllowNull;
import com.github.leeonky.dal.type.Partial;
import com.github.leeonky.dal.type.Schema;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Classes;
import com.github.leeonky.util.CollectionHelper;
import com.github.leeonky.util.PropertyAccessor;
import com.github.leeonky.util.PropertyReader;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Expect {
    protected final BeanClass<Object> type;
    protected final Object expect;

    public Expect(BeanClass<Object> type, Object expect) {
        this.type = type;
        this.expect = expect;
    }

    public boolean isSchema() {
        return this.type.isInheritedFrom(Schema.class);
    }

    public boolean isFormatter() {
        return this.type.isInheritedFrom(Formatter.class);
    }

    public boolean isCollection() {
        return this.type.isCollection();
    }

    public boolean isMap() {
        return this.type.isInheritedFrom(Map.class);
    }

    public boolean isSchemaValue() {
        return this.type.isInheritedFrom(Value.class);
    }

    public boolean isSchemaType() {
        return this.type.isInheritedFrom(Type.class);
    }

    public Expect sub(PropertyReader<Object> propertyReader) {
        return new Expect((BeanClass<Object>)propertyReader.getType(), this.expect == null ? null : propertyReader.getValue(this.expect));
    }

    public Expect sub(BeanClass<Object> type, Object key) {
        return new Expect(type, this.expect == null ? null : ((Map)this.expect).get(key));
    }

    public Expect sub(int index) {
        return this.sub((PropertyReader<Object>)this.type.getPropertyReader(String.valueOf(index)));
    }

    public Optional<Schema> getSchema() {
        return BeanClass.cast((Object)this.expect, Schema.class);
    }

    public Formatter<Object, Object> extractFormatter() {
        if (this.expect == null) {
            return (Formatter)this.type.getTypeArguments(0).map(t -> this.type.newInstance(new Object[]{t.getType()})).orElseGet(() -> this.type.newInstance(new Object[0]));
        }
        return (Formatter)this.expect;
    }

    public Optional<BeanClass<?>> getGenericType(int typePosition) {
        return this.type.getTypeArguments(typePosition);
    }

    public String inspectExpectType() {
        return String.format("type [%s]", this.type.getName());
    }

    public String inspectFullType() {
        return String.format("%s[%s]", this.type.getSimpleName(), this.type.getName());
    }

    public boolean verifyValue(BiPredicate<Value<Object>, BeanClass<?>> predicate) {
        return predicate.test((Value)this.expect, this.getGenericType(0).orElse(null));
    }

    public int mapKeysSize() {
        return ((Map)this.expect).size();
    }

    public int collectionSize() {
        return (int)CollectionHelper.toStream((Object)this.expect).count();
    }

    public Type<Object> extractType() {
        return (Type)this.expect;
    }

    public boolean isInstanceOf(Actual actual) {
        return actual.inInstanceOf(this.type);
    }

    public boolean isInstanceType(Actual actual) {
        return actual.inInstanceOf(this.getGenericType(0).orElseThrow(actual::invalidGenericType));
    }

    public boolean equals(Actual actual, RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
        return actual.equalsExpect(this.expect, runtimeContext);
    }

    public Stream<PropertyReader<Object>> propertyReaders() {
        return this.type.getPropertyReaders().values().stream();
    }

    public boolean structure() {
        return this.expect == null;
    }

    public SchemaExpect asSchema(Actual actual) {
        return new SchemaExpect(actual.polymorphicSchemaType(this.type.getType()), this.expect);
    }

    static class SchemaExpect
    extends Expect {
        public SchemaExpect(Class<Object> schemaType, Object expect) {
            super((BeanClass<Object>)BeanClass.create(schemaType), expect == null ? Classes.newInstance(schemaType, (Object[])new Object[0]) : expect);
        }

        public boolean noMoreUnexpectedField(Set<String> actualFields) {
            if (this.type.getAnnotation(Partial.class) != null) {
                return true;
            }
            LinkedHashSet<String> expectFields = new LinkedHashSet<String>(actualFields){
                {
                    super(x0);
                    this.propertyReaders().map(PropertyAccessor::getName).forEach(this::remove);
                }
            };
            return expectFields.isEmpty() || Verification.errorLog("Unexpected field %s for schema %s", expectFields.stream().collect(Collectors.joining("`, `", "`", "`")), this.inspectFullType());
        }

        public boolean allMandatoryPropertyShouldBeExist(Set<String> actualFields) {
            return this.propertyReaders().filter(field -> field.getAnnotation(AllowNull.class) == null).allMatch(field -> actualFields.contains(field.getName()) || Verification.errorLog("Expected field `%s` to be in type %s, but does not exist", field.getName(), this.inspectFullType()));
        }

        public boolean allPropertyValueShouldBeValid(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual) {
            return this.propertyReaders().allMatch(propertyReader -> {
                Actual subActual = actual.sub(propertyReader.getName());
                return propertyReader.getAnnotation(AllowNull.class) != null && subActual.isNull() || Verification.expect(this.sub((PropertyReader<Object>)propertyReader)).verify(runtimeContext, subActual);
            });
        }

        public boolean verifySchemaInstance(Actual actual) {
            this.getSchema().ifPresent(actual::verifySchema);
            return true;
        }

        public boolean verify(RuntimeContextBuilder.DALRuntimeContext runtimeContext, Actual actual, Set<String> actualFields) {
            return this.noMoreUnexpectedField(actualFields) && this.allMandatoryPropertyShouldBeExist(actualFields) && this.allPropertyValueShouldBeValid(runtimeContext, actual) && this.verifySchemaInstance(actual);
        }
    }
}

