/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast;

import com.github.leeonky.dal.ast.DALNode;
import com.github.leeonky.dal.ast.DALOperator;
import com.github.leeonky.dal.ast.InputNode;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.FunctionUtil;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GroupNode
extends DALNode {
    private final List<DALNode> elements;
    private final List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses = new ArrayList<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>();

    public GroupNode(List<DALNode> elements) {
        this.elements = elements;
    }

    @Override
    public String inspect() {
        return this.elements.stream().map(DALNode::inspect).collect(Collectors.joining(", ", "<<", ">>")) + this.makeVerificationExpression(InputNode.INPUT_NODE).inspect();
    }

    @Override
    public boolean verifyBy(DALNode expected, DALOperator.Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.elements.stream().allMatch(element -> {
            try {
                return this.makeVerificationExpression((DALNode)((Object)element)).verifyBy(expected, operator, context);
            }
            catch (InterpreterException e) {
                throw e.multiPosition(element.getOperandPosition(), InterpreterException.Position.Type.CHAR);
            }
        });
    }

    private DALNode makeVerificationExpression(DALNode element) {
        return this.clauses.stream().reduce(element, (e, clause) -> (DALNode)clause.expression((Node)e), FunctionUtil.notAllowParallelReduce());
    }

    @Override
    public boolean verifyBy(DALNode expected, DALOperator.Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.elements.stream().allMatch(element -> {
            try {
                return this.makeVerificationExpression((DALNode)((Object)element)).verifyBy(expected, operator, context);
            }
            catch (InterpreterException e) {
                throw e.multiPosition(element.getOperandPosition(), InterpreterException.Position.Type.CHAR);
            }
        });
    }

    public GroupNode appendClauseChain(Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause) {
        this.clauses.add(clause);
        return this;
    }
}

