/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.ConstNode;
import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ListEllipsisNode;
import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.ast.node.SymbolNode;
import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Factory;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.DalException;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ElementAssertionFailure;
import com.github.leeonky.dal.runtime.RowAssertionFailure;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.Node;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ListScopeNode
extends DALNode {
    private List<DALNode> verificationExpressions;
    private List<DALNode> inputExpressions;
    private List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> inputClauses;
    private final Type type;
    private final Style style;
    private final Comparator<Object> comparator;

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses, Comparator<Object> comparator, Style style) {
        this.type = this.guessType(clauses);
        this.inputClauses = clauses;
        this.comparator = comparator;
        this.style = style;
    }

    public ListScopeNode(List<DALNode> verificationExpressions, Type type, Comparator<Object> comparator, Style style) {
        this.inputExpressions = new ArrayList<DALNode>(verificationExpressions);
        this.verificationExpressions = this.inputExpressions;
        this.type = type;
        this.comparator = comparator;
        this.style = style;
    }

    public ListScopeNode(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses) {
        this(clauses, SortGroupNode.NOP_COMPARATOR, Style.LIST);
    }

    private void assertListSize(int expected, int actual, int position) {
        if (expected != actual) {
            String message = String.format("Different list size\nExpected: <%d>\nActual: <%d>", expected, actual);
            throw this.style == Style.ROW ? new DifferentCellSize(message, position) : new AssertionFailure(message, position);
        }
    }

    private List<DALNode> getVerificationExpressions(int firstIndex) {
        return this.verificationExpressions != null ? this.verificationExpressions : this.buildVerificationExpressions(firstIndex).stream().filter(node -> !(node instanceof ListEllipsisNode)).collect(Collectors.toList());
    }

    private List<DALNode> buildVerificationExpressions(final int firstIndex) {
        if (this.inputExpressions != null) {
            return this.inputExpressions;
        }
        return new ArrayList<DALNode>(){
            {
                for (int i = 0; i < ListScopeNode.this.inputClauses.size(); ++i) {
                    this.add(((Clause)ListScopeNode.this.inputClauses.get(i)).expression((Node)ListScopeNode.this.getDalExpression(i, firstIndex)));
                }
            }
        };
    }

    private DALExpression getDalExpression(int index, int firstIndex) {
        return new DALExpression(InputNode.INPUT_NODE, Factory.executable(Notations.EMPTY), new SymbolNode(this.type.indexOfNode(firstIndex, index, this.inputClauses.size()), SymbolNode.Type.BRACKET));
    }

    private Type guessType(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses) {
        List isListEllipsis = clauses.stream().map(this::isListEllipsis).collect(Collectors.toList());
        long ellipsesCount = isListEllipsis.stream().filter(Boolean::booleanValue).count();
        if (ellipsesCount > 0L) {
            if (ellipsesCount == 1L) {
                if (((Boolean)isListEllipsis.get(0)).booleanValue()) {
                    return Type.LAST_N_ITEMS;
                }
                if (((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                    return Type.FIRST_N_ITEMS;
                }
            } else if (ellipsesCount == 2L && ((Boolean)isListEllipsis.get(0)).booleanValue() && ((Boolean)isListEllipsis.get(isListEllipsis.size() - 1)).booleanValue()) {
                return Type.CONTAINS;
            }
            throw new SyntaxException("Invalid ellipsis", ((DALNode)clauses.get(isListEllipsis.lastIndexOf(true)).expression(null)).getOperandPosition());
        }
        return Type.ALL_ITEMS;
    }

    @Override
    public String inspect() {
        if (this.type == Type.CONTAINS) {
            return this.inputClauses.stream().map(clause -> ((DALNode)clause.expression((Node)InputNode.INPUT_NODE)).inspect()).collect(Collectors.joining(", ", "[", "]"));
        }
        return this.buildVerificationExpressions(0).stream().map(DALNode::inspect).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    protected boolean verify(Data actual, Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verify(context, actual);
    }

    @Override
    protected boolean verify(Data actual, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return this.verify(context, actual);
    }

    private boolean verify(RuntimeContextBuilder.DALRuntimeContext context, Data data) {
        data.requireList(this.getPositionBegin()).setListComparator(this.comparator);
        return this.type == Type.CONTAINS ? this.verifyContainElement(context, data) : this.verifyCorrespondingElement(context, data).booleanValue();
    }

    private Boolean verifyCorrespondingElement(RuntimeContextBuilder.DALRuntimeContext context, Data data) {
        List<DALNode> expressions = this.getVerificationExpressions(data.getListFirstIndex());
        if (this.type == Type.ALL_ITEMS) {
            this.assertListSize(expressions.size(), data.getListSize(), this.getPositionBegin());
        }
        return data.newBlockScope(() -> this.assertElementExpressions(context, expressions));
    }

    private boolean verifyContainElement(RuntimeContextBuilder.DALRuntimeContext context, Data data) {
        int elementIndex = 0;
        List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> expected = this.trimFirstEllipsis();
        for (int clauseIndex = 0; clauseIndex < expected.size(); ++clauseIndex) {
            Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause = expected.get(clauseIndex);
            try {
                while (!this.isElementPassedVerification(context, clause, this.getElement(data, elementIndex++, clause))) {
                }
                continue;
            }
            catch (AssertionFailure exception) {
                throw this.style == Style.LIST ? exception : new RowAssertionFailure(clauseIndex, exception);
            }
        }
        return true;
    }

    private boolean isElementPassedVerification(RuntimeContextBuilder.DALRuntimeContext context, Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause, Object element) {
        try {
            return (Boolean)((DALNode)clause.expression((Node)new ConstNode(element))).evaluate(context);
        }
        catch (AssertionFailure ignore) {
            return false;
        }
    }

    private Object getElement(Data data, int elementIndex, Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause) {
        if (elementIndex == data.getListSize()) {
            throw new AssertionFailure("No such element", ((DALNode)clause.expression((Node)InputNode.INPUT_NODE)).getOperandPosition());
        }
        return data.getValueList().get(elementIndex);
    }

    private List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> trimFirstEllipsis() {
        return this.inputClauses.subList(1, this.inputClauses.size() - 1);
    }

    private boolean assertElementExpressions(RuntimeContextBuilder.DALRuntimeContext context, List<DALNode> expressions) {
        if (this.style != Style.LIST) {
            for (int index = 0; index < expressions.size(); ++index) {
                try {
                    expressions.get(index).evaluate(context);
                    continue;
                }
                catch (DifferentCellSize differentCellSize) {
                    throw new RowAssertionFailure(index, differentCellSize);
                }
                catch (DalException dalException) {
                    if (this.style == Style.TABLE) {
                        throw new ElementAssertionFailure(index, dalException);
                    }
                    throw dalException;
                }
            }
        } else {
            expressions.forEach(expression -> expression.evaluate(context));
        }
        return true;
    }

    private boolean isListEllipsis(Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode> clause) {
        return clause.expression((Node)InputNode.INPUT_NODE) instanceof ListEllipsisNode;
    }

    static class DifferentCellSize
    extends AssertionFailure {
        public DifferentCellSize(String format, int position) {
            super(format, position);
        }
    }

    public static class ReverseOrder
    extends ListScopeNode {
        public ReverseOrder(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses) {
            super(clauses, Comparator.reverseOrder(), Style.LIST);
        }

        @Override
        public String inspect() {
            return "-" + super.inspect();
        }
    }

    public static class NatureOrder
    extends ListScopeNode {
        public NatureOrder(List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>> clauses) {
            super(clauses, Comparator.naturalOrder(), Style.LIST);
        }

        @Override
        public String inspect() {
            return "+" + super.inspect();
        }
    }

    public static enum Style {
        LIST,
        TABLE,
        ROW;

    }

    public static enum Type {
        ALL_ITEMS,
        FIRST_N_ITEMS,
        LAST_N_ITEMS{

            @Override
            int indexOfNode(int firstIndex, int index, int count) {
                return index - count;
            }
        }
        ,
        CONTAINS;


        int indexOfNode(int firstIndex, int index, int count) {
            return index + firstIndex;
        }
    }
}

