/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.format;

import java.util.Objects;
import java.util.function.Function;

public interface Type<T> {
    public static <T> Type<T> equalTo(final T expect) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return Objects.equals(expect, actual);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be equal to [%s], but was not.", field, actual, expect);
            }
        };
    }

    public static <T> Type<T> nullReference() {
        return new Type<T>(){

            @Override
            public boolean verify(T obj) {
                return Objects.isNull(obj);
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be null, but was not.", field, actual);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> lessThan(T value) {
        return Type.compare(value, i -> i < 0, "less than");
    }

    public static <T extends Comparable<T>> Type<T> compare(final T value, final Function<Integer, Boolean> comparator, final String message) {
        return new Type<T>(){

            @Override
            public boolean verify(T actual) {
                return (Boolean)comparator.apply(((Comparable)Objects.requireNonNull(actual)).compareTo(value));
            }

            @Override
            public String errorMessage(String field, Object actual) {
                return String.format("Expecting field `%s` [%s] to be " + message + " [%s], but was not.", field, actual, value);
            }
        };
    }

    public static <T extends Comparable<T>> Type<T> greaterThan(T value) {
        return Type.compare(value, i -> i > 0, "greater than");
    }

    public static <T extends Comparable<T>> Type<T> lessOrEqualTo(T value) {
        return Type.compare(value, i -> i <= 0, "less or equal to");
    }

    public static <T extends Comparable<T>> Type<T> greaterOrEqualTo(T value) {
        return Type.compare(value, i -> i >= 0, "greater or equal to");
    }

    public boolean verify(T var1);

    public String errorMessage(String var1, Object var2);
}

