/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.opt.Equal;
import com.github.leeonky.dal.ast.opt.Matcher;
import com.github.leeonky.dal.runtime.AssertionFailure;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.NodeBase;
import java.util.List;
import java.util.stream.Stream;

public abstract class DALNode
extends NodeBase<RuntimeContextBuilder.DALRuntimeContext, DALNode> {
    public Data evaluateData(RuntimeContextBuilder.DALRuntimeContext context) {
        return context.wrap(this.evaluate(context));
    }

    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        return this.evaluateData(context).getInstance();
    }

    public boolean verifyBy(DALNode expected, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return expected.verify(this, operator, context);
    }

    public boolean verifyBy(DALNode expected, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return expected.verify(this, operator, context);
    }

    public boolean verify(DALNode actualNode, Equal operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode.evaluateData(context), operator, context, actualNode);
    }

    public boolean verify(DALNode actualNode, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context) {
        return this.verify(actualNode.evaluateData(context), operator, context, actualNode);
    }

    protected boolean verify(Data actual, Equal operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        return AssertionFailure.assertEquals(this.evaluateData(context), actual, this.getPositionBegin());
    }

    protected boolean verify(Data actual, Matcher operator, RuntimeContextBuilder.DALRuntimeContext context, DALNode actualNode) {
        Data expected = this.evaluateData(context);
        if (expected.isNull()) {
            return AssertionFailure.assertMatchNull(actual, actualNode.getPositionBegin());
        }
        this.invalidTypeToMatchValue(String.class, actual, Number.class, expected, operator);
        this.invalidTypeToMatchValue(String.class, actual, Boolean.class, expected, operator);
        this.invalidTypeToMatchValue(Number.class, actual, String.class, expected, operator);
        this.invalidTypeToMatchValue(Boolean.class, actual, String.class, expected, operator);
        return AssertionFailure.assertMatch(expected, actual, this.getPositionBegin(), context.getNumberType());
    }

    public abstract String inspect();

    private void invalidTypeToMatchValue(Class<?> actualType, Data actual, Class<?> expectedType, Data expected, Matcher operator) {
        if (actualType.isInstance(actual.getInstance()) && expectedType.isInstance(expected.getInstance())) {
            throw new RuntimeException(String.format("Cannot compare between %sand %s", actual.inspect(), expected.inspect()).trim(), operator.getPosition());
        }
    }

    public Object getRootSymbolName() {
        return null;
    }

    public List<Object> propertyChain() {
        throw new IllegalStateException();
    }

    public Stream<Object> collectFields(Data data) {
        return Stream.of(data.firstFieldFromAlias(this.getRootSymbolName()));
    }
}

