/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.compiler;

import com.github.leeonky.dal.ast.node.ConstNode;
import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.GroupExpression;
import com.github.leeonky.dal.ast.node.InputNode;
import com.github.leeonky.dal.ast.node.ListEllipsisNode;
import com.github.leeonky.dal.ast.node.ListMappingNode;
import com.github.leeonky.dal.ast.node.ListMappingNodeMeta;
import com.github.leeonky.dal.ast.node.ListScopeNode;
import com.github.leeonky.dal.ast.node.NodeFactory;
import com.github.leeonky.dal.ast.node.ObjectScopeNode;
import com.github.leeonky.dal.ast.node.PropertyPattern;
import com.github.leeonky.dal.ast.node.PropertyThis;
import com.github.leeonky.dal.ast.node.SortGroupNode;
import com.github.leeonky.dal.ast.node.SortSymbolNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.TransposedTableNode;
import com.github.leeonky.dal.ast.node.WildcardNode;
import com.github.leeonky.dal.ast.node.table.EmptyTransposedTableHead;
import com.github.leeonky.dal.ast.node.table.HeaderNode;
import com.github.leeonky.dal.ast.node.table.TableBody;
import com.github.leeonky.dal.ast.node.table.TableDefaultIndexHeadRow;
import com.github.leeonky.dal.ast.node.table.TableHeadRow;
import com.github.leeonky.dal.ast.node.table.TableRowNode;
import com.github.leeonky.dal.ast.node.table.TableRowPrefixNode;
import com.github.leeonky.dal.ast.node.table.TransposedRowNode;
import com.github.leeonky.dal.ast.node.table.TransposedTableBody;
import com.github.leeonky.dal.ast.node.table.TransposedTableHead;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.Constants;
import com.github.leeonky.dal.compiler.DALProcedure;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.compiler.Operators;
import com.github.leeonky.dal.compiler.Tokens;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.Clause;
import com.github.leeonky.interpreter.ClauseParser;
import com.github.leeonky.interpreter.EscapeChars;
import com.github.leeonky.interpreter.ExpressionFactory;
import com.github.leeonky.interpreter.NodeParser;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.interpreter.OperatorParser;
import com.github.leeonky.interpreter.Parser;
import com.github.leeonky.interpreter.Procedure;
import com.github.leeonky.interpreter.Rules;
import com.github.leeonky.interpreter.SourceCode;
import com.github.leeonky.interpreter.Syntax;
import com.github.leeonky.util.function.When;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class Compiler {
    private static final EscapeChars SINGLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\'", '\'');
    private static final EscapeChars DOUBLE_QUOTED_ESCAPES = new EscapeChars().escape("\\\\", '\\').escape("\\n", '\n').escape("\\r", '\r').escape("\\t", '\t').escape("\\\"", '\"');
    private static final EscapeChars REGEX_ESCAPES = new EscapeChars().escape("\\/", '/');
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SORTED_LIST;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PARENTHESES;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_SPECIAL_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_VALUE_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SHORT_VERIFICATION_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CELL_VERIFICATION_OPERAND;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> GROUP_PROPERTY;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPTIONAL_PROPERTY_CHAIN;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INPUT = procedure -> When.when((boolean)procedure.isCodeBeginning()).optional(() -> InputNode.INPUT_NODE);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> NUMBER = Tokens.NUMBER.nodeParser(NodeFactory::constNumber);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INTEGER = Tokens.INTEGER.nodeParser(NodeFactory::constInteger);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SINGLE_QUOTED_STRING = Notations.SINGLE_QUOTED.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(SINGLE_QUOTED_ESCAPES)).and(Rules.endWith((String)Notations.SINGLE_QUOTED.getLabel())).as(NodeFactory::constString));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DOUBLE_QUOTED_STRING = Notations.DOUBLE_QUOTED.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(DOUBLE_QUOTED_ESCAPES)).and(Rules.endWith((String)Notations.DOUBLE_QUOTED.getLabel())).as(NodeFactory::constString));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_TRUE = Notations.Keywords.TRUE.wordNode(NodeFactory::constTrue, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_FALSE = Notations.Keywords.FALSE.wordNode(NodeFactory::constFalse, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_NULL = Notations.Keywords.NULL.wordNode(NodeFactory::constNull, Constants.PROPERTY_DELIMITER_STRING);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST_USER_DEFINED_LITERAL = this::compileUserDefinedLiteral;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> REGEX = Notations.OPEN_REGEX.with((NodeParser.Mandatory)Syntax.many(Compiler.charNode(REGEX_ESCAPES)).and(Rules.endWith((String)Notations.CLOSE_REGEX.getLabel())).as(NodeFactory::regex));
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WILDCARD = Notations.Operators.WILDCARD.node(WildcardNode::new);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_WILDCARD = Notations.Operators.ROW_WILDCARD.node(WildcardNode::new);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> CONST = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.NUMBER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING, this.CONST_TRUE, this.CONST_FALSE, this.CONST_NULL, this.CONST_USER_DEFINED_LITERAL});
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ELEMENT_ELLIPSIS = Notations.Operators.ELEMENT_ELLIPSIS.node(token -> new ListEllipsisNode());
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA = Tokens.SCHEMA.nodeParser(NodeFactory::schema);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> INTEGER_OR_STRING = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.INTEGER, this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING});
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> STRING_PROPERTY = procedure -> procedure.isEnableRelaxProperty() ? ((NodeParser)Syntax.single((Parser)Parser.oneOf((Parser[])new NodeParser[]{this.SINGLE_QUOTED_STRING, this.DOUBLE_QUOTED_STRING})).as(NodeFactory::stringSymbol)).parse(procedure) : Optional.empty();
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> NUMBER_PROPERTY = procedure -> procedure.isEnableNumberProperty() ? ((NodeParser)Syntax.single(this.NUMBER).as(NodeFactory::numberSymbol)).parse(procedure) : Optional.empty();
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SYMBOL = procedure -> (procedure.isEnableRelaxProperty() ? Tokens.RELAX_SYMBOL : Tokens.SYMBOL).nodeParser(NodeFactory::symbolNode).parse(procedure);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DOT_SYMBOL = procedure -> (procedure.isEnableRelaxProperty() ? Tokens.RELAX_DOT_SYMBOL : Tokens.DOT_SYMBOL).nodeParser(NodeFactory::symbolNode).parse(procedure);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> META_SYMBOL = Tokens.DOT_SYMBOL.nodeParser(NodeFactory::metaSymbolNode);
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_PATTERN = this::propertyPattern;
    NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPTIONAL_VERIFICATION_PROPERTY = Parser.lazyNode(() -> DALProcedure.enableSlashProperty(DALProcedure.enableRelaxProperty(this.OPTIONAL_PROPERTY_CHAIN)));
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> PROPERTY_CHAIN;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OPERAND;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_PROPERTY;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT_VERIFICATION_PROPERTY;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DEFAULT_INPUT = procedure -> InputNode.INPUT_NODE;
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_COMPOSE = (NodeParser.Mandatory)Notations.OPENING_BRACKET.with((NodeParser.Mandatory)Syntax.single((Parser.Mandatory)((Parser.Mandatory)Syntax.many((Parser.Mandatory)this.SCHEMA.mandatory("Expect a schema")).and(Rules.splitBy((Notation)Notations.SCHEMA_AND)).as(NodeFactory::elementSchemas))).and(Rules.endWith((Notation)Notations.CLOSING_BRACKET)).as()).or((Parser.Mandatory)Syntax.many((Parser.Mandatory)this.SCHEMA.mandatory("Expect a schema")).and(Rules.splitBy((Notation)Notations.SCHEMA_AND)).as(NodeFactory::schemas));
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION_RELAX_STRING = Tokens.EXPRESSION_RELAX_STRING.nodeParser(NodeFactory::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> OBJECT_SCOPE_RELAX_STRING = Tokens.OBJECT_SCOPE_RELAX_STRING.nodeParser(NodeFactory::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST_SCOPE_RELAX_STRING = Tokens.LIST_SCOPE_RELAX_STRING.nodeParser(NodeFactory::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_CELL_RELAX_STRING = Tokens.TABLE_CELL_RELAX_STRING.nodeParser(NodeFactory::relaxString);
    public NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> DEFAULT_INDEX_HEADER = procedure -> new TableDefaultIndexHeadRow();
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ARITHMETIC_CLAUSE;
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_CLAUSE;
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_CLAUSE = Operators.IS.clause(this.SCHEMA_COMPOSE);
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WHICH_CLAUSE = Parser.lazyClause(() -> Operators.WHICH.clause(this.EXPRESSION));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ELEMENT_ELLIPSIS_CLAUSE = Notations.Operators.ELEMENT_ELLIPSIS.clause((token, input) -> new ListEllipsisNode());
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_WILDCARD_CLAUSE = Notations.Operators.ROW_WILDCARD.clause((token, input) -> new WildcardNode(token.getContent()));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> LIST_MAPPING_CLAUSE = Notations.LIST_MAPPING.clause((token, symbolNode) -> new ListMappingNode((DALNode)((Object)symbolNode)));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> META_LIST_MAPPING_CLAUSE = Notations.LIST_MAPPING.clause((token, symbolNode) -> new ListMappingNodeMeta((DALNode)((Object)symbolNode)));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> IMPLICIT_PROPERTY_CLAUSE = Operators.PROPERTY_IMPLICIT.clause((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.PROPERTY_PATTERN, ((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.STRING_PROPERTY, this.NUMBER_PROPERTY, this.SYMBOL})).concat(this.LIST_MAPPING_CLAUSE)}));
    public ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPLICIT_PROPERTY_CLAUSE = (ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{Operators.PROPERTY_DOT.clause((NodeParser.Mandatory)this.PROPERTY_PATTERN.or(this.propertyChainNode())), Operators.PROPERTY_SLASH.clause(this.propertyChainNode()), Operators.PROPERTY_IMPLICIT.clause(Notations.OPENING_BRACKET.with(((NodeParser.Mandatory)Syntax.single((Parser.Mandatory)this.INTEGER_OR_STRING.mandatory("Should given one property or array index in `[]`")).and(Rules.endWith((Notation)Notations.CLOSING_BRACKET)).as(NodeFactory::bracketSymbolNode)).concat(this.LIST_MAPPING_CLAUSE))), Operators.PROPERTY_META.clause(this.symbolClause((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)this.META_SYMBOL.concat(this.META_LIST_MAPPING_CLAUSE)))});
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ARITHMETIC_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> VERIFICATION_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPLICIT_PROPERTY_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> WHICH_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SCHEMA_CLAUSE_CHAIN;
    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EXPRESSION_CLAUSE;
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_AZ = Notations.SEQUENCE_AZ.node(SortSymbolNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_ZA = Notations.SEQUENCE_ZA.node(SortSymbolNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_AZ_2 = Notations.SEQUENCE_AZ_2.node(SortSymbolNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE_ZA_2 = Notations.SEQUENCE_ZA_2.node(SortSymbolNode::new);
    private final NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_KEY = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.INTEGER, this.OPTIONAL_VERIFICATION_PROPERTY});
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> SEQUENCE = (NodeParser.Mandatory)((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{(NodeParser)Syntax.many(this.SEQUENCE_AZ).and(Rules.atLeast((int)1)).as(SortGroupNode::new), (NodeParser)Syntax.many(this.SEQUENCE_AZ_2).and(Rules.atLeast((int)1)).as(SortGroupNode::new), (NodeParser)Syntax.many(this.SEQUENCE_ZA).and(Rules.atLeast((int)1)).as(SortGroupNode::new), (NodeParser)Syntax.many(this.SEQUENCE_ZA_2).and(Rules.atLeast((int)1)).as(SortGroupNode::new)})).or((Parser.Mandatory)((NodeParser.Mandatory)procedure -> SortGroupNode.noSequence()));
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> EMPTY_TRANSPOSED_HEAD = procedure -> new EmptyTransposedTableHead();
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> ROW_PREFIX = procedure -> new TableRowPrefixNode(this.ROW_KEY.parse(procedure), this.SCHEMA_CLAUSE.parse(procedure), Operators.VERIFICATION_OPERATORS.parse(procedure));
    private final NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_HEADER = procedure -> new HeaderNode((SortGroupNode)((Object)((Object)this.SEQUENCE.parse(procedure))), (DALNode)((Object)((Object)this.VERIFICATION_PROPERTY.concat(this.SCHEMA_CLAUSE).parse(procedure))), Operators.VERIFICATION_OPERATORS.parse(procedure));
    private final ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> TABLE_BODY_CLAUSE = procedure -> head -> new TableNode((TableHeadRow)head, (TableBody)((Object)((Object)((Object)((NodeParser.Mandatory)Syntax.many((Parser)this.ROW_PREFIX.with((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{(ClauseParser)Notations.COLUMN_SPLITTER.before(this.singleCellRow(this.ELEMENT_ELLIPSIS, (TableHeadRow)head)), (ClauseParser)Notations.COLUMN_SPLITTER.before(this.singleCellRow(this.ROW_WILDCARD, (TableHeadRow)head)), (ClauseParser)Notations.COLUMN_SPLITTER.before(this.tableRow((TableHeadRow)head))}))).and(Rules.endWithOptionalLine()).as(TableBody::new)).parse(procedure)))));

    private Optional<DALNode> propertyPattern(DALProcedure dalProcedure) {
        ClauseParser patternClause = Notation.notation((String)"{}").clause((token, symbol) -> new PropertyPattern((DALNode)((Object)symbol)));
        return ((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Notation.notation((String)"{}").node(n -> new PropertyThis()), this.SYMBOL.with(patternClause)})).parse((Procedure)dalProcedure);
    }

    private NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> propertyChainNode() {
        return this.symbolClause((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.STRING_PROPERTY, this.DOT_SYMBOL, this.NUMBER_PROPERTY, Parser.lazyNode(() -> this.GROUP_PROPERTY)})).concat(this.LIST_MAPPING_CLAUSE));
    }

    private NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> symbolClause(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser) {
        return (NodeParser.Mandatory)nodeParser.mandatory("Expect a symbol");
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> shortVerificationClause(OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> operatorMandatory, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> operand) {
        return (ClauseParser.Mandatory)this.SCHEMA_CLAUSE.concat(Operators.VERIFICATION_OPERATORS.clause(operand)).or((Parser.Mandatory)operatorMandatory.clause(operand));
    }

    public Compiler() {
        this.PARENTHESES = Parser.lazyNode(() -> DALProcedure.enableCommaAnd((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)Notations.OPENING_PARENTHESES.with((NodeParser.Mandatory)Syntax.single(this.EXPRESSION).and(Rules.endWith((Notation)Notations.CLOSING_PARENTHESES)).as(NodeFactory::parenthesesNode))));
        this.PROPERTY = Parser.lazyNode(() -> (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.GROUP_PROPERTY, this.DEFAULT_INPUT.with((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.EXPLICIT_PROPERTY_CLAUSE, this.IMPLICIT_PROPERTY_CLAUSE}))}));
        this.OPTIONAL_PROPERTY_CHAIN = this.PROPERTY.concatAll(this.EXPLICIT_PROPERTY_CLAUSE);
        this.PROPERTY_CHAIN = (NodeParser.Mandatory)this.OPTIONAL_PROPERTY_CHAIN.mandatory("Expect a object property");
        this.VERIFICATION_PROPERTY = DALProcedure.enableNumberProperty(DALProcedure.enableRelaxProperty(DALProcedure.enableSlashProperty(this.PROPERTY_CHAIN)));
        this.OBJECT_VERIFICATION_PROPERTY = (NodeParser.Mandatory)Syntax.many(this.VERIFICATION_PROPERTY).and(Rules.optionalSplitBy((Notation)Notations.COMMA)).and(Rules.endBefore((Notation[])new Notation[]{Notations.Operators.EQUAL, Notations.Operators.MATCHER, Notations.Operators.IS})).as(NodeFactory::createVerificationGroup);
        this.OBJECT = Parser.lazyNode(() -> DALProcedure.disableCommaAnd((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)Notations.OPENING_BRACES.with((NodeParser.Mandatory)((NodeParser)Syntax.single(this.ELEMENT_ELLIPSIS).and(Rules.endWith((Notation)Notations.CLOSING_BRACES)).as(ObjectScopeNode::new)).or((Parser.Mandatory)Syntax.many((Parser.Mandatory)this.OBJECT_VERIFICATION_PROPERTY.concat(this.shortVerificationClause((OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((OperatorParser.Mandatory)Operators.VERIFICATION_OPERATORS.mandatory("Expect operator `:` or `=`")), (NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((NodeParser.Mandatory)this.SHORT_VERIFICATION_OPERAND.or(this.OBJECT_SCOPE_RELAX_STRING))))).and(Rules.optionalSplitBy((Notation)Notations.COMMA)).and(Rules.endWith((Notation)Notations.CLOSING_BRACES)).as(ObjectScopeNode::new)))));
        this.SORTED_LIST = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{(NodeParser)Notations.Operators.PLUS.before(this.pureList(ListScopeNode.NatureOrder::new)), (NodeParser)Notations.Operators.SUBTRACTION.before(this.pureList(ListScopeNode.ReverseOrder::new))});
        this.LIST = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.pureList(ListScopeNode::new), this.SORTED_LIST});
        this.TABLE = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Notations.TRANSPOSE_MARK.with(this.EMPTY_TRANSPOSED_HEAD.with(this.transposeTable())), NodeParser.positionNode((NodeParser)((NodeParser)Notations.COLUMN_SPLITTER.before(Notations.TRANSPOSE_MARK.before(Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Compiler.tableLine(this.ROW_PREFIX).as(TransposedTableHead::new)))))).concat(this.transposeTable()), NodeParser.positionNode((NodeParser)((NodeParser)Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Compiler.tableLine(this.TABLE_HEADER).as(TableHeadRow::new)))).concat(this.TABLE_BODY_CLAUSE), NodeParser.positionNode((NodeParser)((NodeParser)Notations.MATRIX_COLUMN_SPLITTER.before(this.DEFAULT_INDEX_HEADER)).concat(this.TABLE_BODY_CLAUSE))});
        this.VERIFICATION_SPECIAL_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.REGEX, this.OBJECT, this.LIST, this.WILDCARD, this.TABLE});
        this.OPERAND = (NodeParser.Mandatory)Parser.lazyNode(() -> (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Operators.UNARY_OPERATORS.unary(this.OPERAND), this.CONST, this.PROPERTY, this.PARENTHESES, this.INPUT})).mandatory("Expect a value or expression");
        this.VERIFICATION_VALUE_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{Operators.UNARY_OPERATORS.unary(this.OPERAND), this.CONST, this.DEFAULT_INPUT.with(this.EXPLICIT_PROPERTY_CLAUSE), this.PARENTHESES});
        this.ARITHMETIC_CLAUSE = Operators.BINARY_ARITHMETIC_OPERATORS.clause(this.OPERAND);
        this.VERIFICATION_CLAUSE = Operators.VERIFICATION_OPERATORS.clause((NodeParser.Mandatory)((NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.VERIFICATION_SPECIAL_OPERAND, this.VERIFICATION_VALUE_OPERAND})).or(this.EXPRESSION_RELAX_STRING));
        this.ARITHMETIC_CLAUSE_CHAIN = Parser.lazyClause(() -> this.ARITHMETIC_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.VERIFICATION_CLAUSE_CHAIN = Parser.lazyClause(() -> this.VERIFICATION_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.EXPLICIT_PROPERTY_CHAIN = Parser.lazyClause(() -> this.EXPLICIT_PROPERTY_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.WHICH_CLAUSE_CHAIN = Parser.lazyClause(() -> this.WHICH_CLAUSE.concat(this.EXPRESSION_CLAUSE));
        this.SCHEMA_CLAUSE_CHAIN = Parser.lazyClause(() -> this.SCHEMA_CLAUSE.concat((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.VERIFICATION_CLAUSE_CHAIN, this.WHICH_CLAUSE_CHAIN, this.SCHEMA_CLAUSE_CHAIN})));
        this.EXPRESSION_CLAUSE = (ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE_CHAIN, this.VERIFICATION_CLAUSE_CHAIN, this.EXPLICIT_PROPERTY_CHAIN, this.WHICH_CLAUSE_CHAIN, this.SCHEMA_CLAUSE_CHAIN});
        this.EXPRESSION = this.OPERAND.concat(this.EXPRESSION_CLAUSE);
        this.SHORT_VERIFICATION_OPERAND = (NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.VERIFICATION_SPECIAL_OPERAND, this.VERIFICATION_VALUE_OPERAND.concatAll((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE}))});
        this.CELL_VERIFICATION_OPERAND = (NodeParser)Syntax.single((Parser)Parser.oneOf((Parser[])new NodeParser[]{(NodeParser)Parser.oneOf((Parser[])new NodeParser[]{this.REGEX, this.OBJECT, this.LIST, this.WILDCARD}), this.VERIFICATION_VALUE_OPERAND.concatAll((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ARITHMETIC_CLAUSE}))})).and(Rules.enabledBefore((Notation)Notations.COLUMN_SPLITTER)).as();
        this.GROUP_PROPERTY = DALProcedure.disableCommaAnd((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)Notations.OPENING_GROUP.with((NodeParser.Mandatory)Syntax.many(this.VERIFICATION_PROPERTY).and(Rules.optionalSplitBy((Notation)Notations.COMMA)).and(Rules.endWith((Notation)Notations.CLOSING_GROUP)).as(GroupExpression::new)));
    }

    private NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> pureList(Function<List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>, DALNode> factory) {
        return Parser.lazyNode(() -> DALProcedure.disableCommaAnd((NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)Notations.OPENING_BRACKET.with((NodeParser.Mandatory)Syntax.many((Parser.Mandatory)this.ELEMENT_ELLIPSIS_CLAUSE.or(this.shortVerificationClause((OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((OperatorParser.Mandatory)Operators.VERIFICATION_OPERATORS.or(Operators.DEFAULT_VERIFICATION_OPERATOR)), (NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((NodeParser.Mandatory)this.SHORT_VERIFICATION_OPERAND.or(this.LIST_SCOPE_RELAX_STRING))))).and(Rules.optionalSplitBy((Notation)Notations.COMMA)).and(Rules.endWith((Notation)Notations.CLOSING_BRACKET)).as(factory))));
    }

    public List<DALNode> compile(final SourceCode sourceCode, final RuntimeContextBuilder.DALRuntimeContext DALRuntimeContext2) {
        return new ArrayList<DALNode>(){
            {
                DALProcedure dalParser = new DALProcedure(sourceCode, DALRuntimeContext2, (ExpressionFactory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator>)((ExpressionFactory)DALExpression::new));
                this.add(Compiler.this.EXPRESSION.parse((Procedure)dalParser));
                if (sourceCode.isBeginning() && sourceCode.hasCode()) {
                    throw sourceCode.syntaxError("Unexpected token", 0);
                }
                while (sourceCode.hasCode()) {
                    this.add(Compiler.this.EXPRESSION.parse((Procedure)dalParser));
                }
            }
        };
    }

    private static NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> charNode(EscapeChars escapeChars) {
        return procedure -> new ConstNode(Character.valueOf(procedure.getSourceCode().popChar((Map)escapeChars)));
    }

    public List<Object> toChainNodes(String sourceCode) {
        return ((DALNode)((Object)this.PROPERTY_CHAIN.parse((Procedure)new DALProcedure(new SourceCode(sourceCode, Notations.LINE_COMMENTS), null, (ExpressionFactory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator>)((ExpressionFactory)DALExpression::new))))).propertyChain();
    }

    private ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> singleCellRow(NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> nodeParser, TableHeadRow head) {
        return ((NodeParser)Syntax.single((Parser)((Parser)Syntax.single(nodeParser).and(Rules.endWith((Notation)Notations.COLUMN_SPLITTER)).as())).and(Rules.endWithLine()).as()).clause((prefix, cell) -> new TableRowNode((DALNode)((Object)prefix), (DALNode)((Object)cell), head));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> tableCell(DALNode rowPrefix, TableHeadRow head) {
        return ClauseParser.positionClause((ClauseParser.Mandatory)ClauseParser.columnMandatory(column -> this.shortVerificationClause((OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((OperatorParser.Mandatory)((OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Operators.VERIFICATION_OPERATORS, head.getHeader((int)column).operator(), ((TableRowPrefixNode)rowPrefix).operator()})).or(Operators.DEFAULT_VERIFICATION_OPERATOR)), (NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((NodeParser.Mandatory)this.CELL_VERIFICATION_OPERAND.or(this.TABLE_CELL_RELAX_STRING)))));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> tableRow(TableHeadRow headRow) {
        return ClauseParser.Mandatory.clause(rowPrefix -> (NodeParser.Mandatory)Compiler.tableLine(this.tableCell((DALNode)((Object)rowPrefix), headRow)).as(cells -> new TableRowNode((DALNode)((Object)rowPrefix), (List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>)cells, headRow)));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> transposeTableCell(DALNode prefix, DALNode header) {
        return ClauseParser.positionClause((ClauseParser.Mandatory)ClauseParser.columnMandatory(column -> (ClauseParser.Mandatory)((ClauseParser)Parser.oneOf((Parser[])new ClauseParser[]{this.ELEMENT_ELLIPSIS_CLAUSE, this.ROW_WILDCARD_CLAUSE})).or(this.shortVerificationClause((OperatorParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((OperatorParser.Mandatory)((OperatorParser)Parser.oneOf((Parser[])new OperatorParser[]{Operators.VERIFICATION_OPERATORS, ((HeaderNode)prefix).operator(), ((TransposedTableHead)header).getPrefix((int)column).operator()})).or(Operators.DEFAULT_VERIFICATION_OPERATOR)), (NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>)((NodeParser.Mandatory)this.CELL_VERIFICATION_OPERAND.or(this.TABLE_CELL_RELAX_STRING))))));
    }

    private ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> transposeTable() {
        return procedure -> header -> new TransposedTableNode((DALNode)header, (DALNode)((Object)((Object)((Object)((NodeParser.Mandatory)((NodeParser)Syntax.many((Parser)NodeParser.positionNode((NodeParser)((NodeParser)Notations.COLUMN_SPLITTER.before((Parser.Mandatory)Syntax.single(this.TABLE_HEADER).and(Rules.endWith((Notation)Notations.COLUMN_SPLITTER)).as()))).concat(ClauseParser.Mandatory.clause(prefix -> (NodeParser.Mandatory)Compiler.tableLine(this.transposeTableCell((DALNode)((Object)((Object)((Object)prefix))), (DALNode)header)).as(cells -> new TransposedRowNode((DALNode)((Object)((Object)((Object)prefix))), (List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>)cells))))).and(Rules.atLeast((int)1)).and(Rules.endWithOptionalLine()).as(TransposedTableBody::new)).mandatory("Expecting a table")).parse(procedure)))));
    }

    private static Syntax<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure, NodeParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, DALNode, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, List<DALNode>> tableLine(NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return Syntax.many(mandatory).and(Rules.mandatorySplitBy((Notation)Notations.COLUMN_SPLITTER)).and(Rules.endOfRow((Notation)Notations.COLUMN_SPLITTER));
    }

    private static Syntax<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure, ClauseParser<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>, NodeParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure>, List<Clause<RuntimeContextBuilder.DALRuntimeContext, DALNode>>> tableLine(ClauseParser.Mandatory<RuntimeContextBuilder.DALRuntimeContext, DALNode, DALExpression, DALOperator, DALProcedure> mandatory) {
        return Syntax.many(mandatory).and(Rules.mandatorySplitBy((Notation)Notations.COLUMN_SPLITTER)).and(Rules.endOfRow((Notation)Notations.COLUMN_SPLITTER));
    }

    private Optional<DALNode> compileUserDefinedLiteral(DALProcedure dalProcedure) {
        return dalProcedure.getSourceCode().tryFetch(() -> Tokens.SYMBOL.scan(dalProcedure.getSourceCode()).flatMap(token -> ((RuntimeContextBuilder.DALRuntimeContext)dalProcedure.getRuntimeContext()).takeUserDefinedLiteral(token.getContent()).map(result -> (DALNode)new ConstNode(result.getValue()).setPositionBegin(token.getPosition()))));
    }
}

