/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.opt;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.ast.node.SchemaComposeNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.util.function.TriFunction;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Factory {
    public static DALOperator logical(Notation<?, ?, ?> notation, NodeNodeContextObject.SupplierSupplierObject logical) {
        return new Operator(200, notation, NodeNodeContextObject.adapt(logical), true);
    }

    public static DALOperator plusSub(Notation<?, ?, ?> notation, NodeNodeContextObject.ObjectObjectContextObject plusSub) {
        return new Operator(300, notation, NodeNodeContextObject.adapt(plusSub), false);
    }

    public static DALOperator mulDiv(Notation<?, ?, ?> notation, NodeNodeContextObject.ObjectObjectContextObject mulDiv) {
        return new Operator(400, notation, NodeNodeContextObject.adapt(mulDiv), false);
    }

    public static DALOperator comparator(Notation<?, ?, ?> notation, NodeNodeContextObject operation) {
        return new Operator(210, notation, operation, true);
    }

    public static DALOperator unary(final Notation<?, ?, ?> notation, NodeNodeContextObject unary) {
        return new Operator(500, notation, unary, true){

            @Override
            public String inspect(String node1, String node2) {
                return notation.getLabel() + node2;
            }
        };
    }

    public static DALOperator parentheses() {
        return new DALOperator(Integer.MAX_VALUE, "", false){

            @Override
            public Data calculateData(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
                return right.evaluateData(context);
            }

            @Override
            public String inspect(String node1, String node2) {
                return String.format("(%s)", node2);
            }
        };
    }

    public static DALOperator executable(Notation<?, ?, ?> notation) {
        return new DALOperator(501, notation.getLabel(), false){

            @Override
            public Data calculateData(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((ExecutableNode)((Object)right)).getValue(left, context);
            }

            @Override
            public String inspect(String node1, String node2) {
                return String.format("%s%s%s", node1, this.label, node2);
            }
        };
    }

    public static DALOperator is() {
        return new DALOperator(210, Notations.Operators.IS.getLabel(), true){

            @Override
            public Data calculateData(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((SchemaComposeNode)right).verify(left, context);
            }
        };
    }

    public static DALOperator which() {
        return new DALOperator(100, Notations.Operators.WHICH.getLabel(), true){

            @Override
            public Object calculate(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
                try {
                    return left.evaluateData(context).newBlockScope(() -> right.evaluate(context));
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException(e.getMessage(), this.getPosition());
                }
            }
        };
    }

    public static DALOperator remark() {
        return new DALOperator(499, "", true){

            @Override
            public Data calculateData(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
                Data leftValue = left.evaluateData(context);
                Data rightValue = right.evaluateData(context);
                if (Objects.equals(leftValue.getInstance(), rightValue.getInstance())) {
                    return leftValue;
                }
                throw new RuntimeException(String.format("Incorrect const remark, const value was %s\nbut remark %s was %s", leftValue.dumpAll(), right.inspect(), rightValue.dumpAll()), right.getPositionBegin());
            }

            @Override
            public String inspect(String node1, String node2) {
                return node1 + " " + node2;
            }
        };
    }

    static class Operator
    extends DALOperator {
        private final NodeNodeContextObject operation;

        public Operator(int precedence, Notation<?, ?, ?> notation, NodeNodeContextObject operation, boolean needInspect) {
            super(precedence, notation.getLabel(), needInspect);
            this.operation = operation;
        }

        @Override
        public Object calculate(DALNode left, DALNode right, RuntimeContextBuilder.DALRuntimeContext context) {
            return this.operation.apply((Object)left, (Object)right, context);
        }
    }

    public static interface NodeNodeContextObject
    extends TriFunction<DALNode, DALNode, RuntimeContextBuilder.DALRuntimeContext, Object> {
        public static NodeNodeContextObject adapt(SupplierSupplierObject operation) {
            return (left, right, context) -> operation.apply(() -> left.evaluate((RuntimeContextBuilder.DALRuntimeContext)context), () -> right.evaluate((RuntimeContextBuilder.DALRuntimeContext)context));
        }

        public static NodeNodeContextObject adapt(ObjectObjectContextObject operation) {
            return (left, right, context) -> operation.apply(left.evaluate((RuntimeContextBuilder.DALRuntimeContext)context), right.evaluate((RuntimeContextBuilder.DALRuntimeContext)context), context);
        }

        public static NodeNodeContextObject adapt(DataContextObject operation) {
            return (left, right, context) -> operation.apply(right.evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), context);
        }

        public static NodeNodeContextObject adapt(ObjectObject operation) {
            return (left, right, context) -> operation.apply(right.evaluate((RuntimeContextBuilder.DALRuntimeContext)context));
        }

        public static NodeNodeContextObject adapt(DataDataObject operation) {
            return (left, right, context) -> operation.apply(left.evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), right.evaluateData((RuntimeContextBuilder.DALRuntimeContext)context));
        }

        public static interface DataDataObject
        extends BiFunction<Data, Data, Object> {
        }

        public static interface ObjectObject
        extends Function<Object, Object> {
        }

        public static interface DataContextObject
        extends BiFunction<Data, RuntimeContextBuilder.DALRuntimeContext, Object> {
        }

        public static interface ObjectObjectContextObject
        extends TriFunction<Object, Object, RuntimeContextBuilder.DALRuntimeContext, Object> {
        }

        public static interface SupplierSupplierObject
        extends BiFunction<Supplier<Object>, Supplier<Object>, Object> {
        }
    }
}

