/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.util.InvocationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MetaData {
    private final DALNode metaDataNode;
    private final DALNode symbolNode;
    private final RuntimeContextBuilder.DALRuntimeContext runtimeContext;
    private Data data;
    private Throwable error;
    private RuntimeException originalException;
    private Object name;
    private final List<Class<?>> callTypes = new ArrayList();

    public MetaData(DALNode metaDataNode, DALNode symbolNode, RuntimeContextBuilder.DALRuntimeContext runtimeContext) {
        this.metaDataNode = metaDataNode;
        this.symbolNode = symbolNode;
        this.runtimeContext = runtimeContext;
        this.name = symbolNode.getRootSymbolName();
        this.setData(() -> this.getMetaDataNode().evaluateData(this.getRuntimeContext()));
    }

    public MetaData(DALNode metaDataNode, DALNode symbolNode, RuntimeContextBuilder.DALRuntimeContext runtimeContext, Data data, Throwable error, RuntimeException originalException, String name) {
        this.metaDataNode = metaDataNode;
        this.symbolNode = symbolNode;
        this.runtimeContext = runtimeContext;
        this.name = name;
        this.data = data;
        this.error = error;
        this.originalException = originalException;
    }

    private void setData(Supplier<Data> supplier) {
        try {
            this.data = supplier.get();
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof InvocationException)) {
                throw e;
            }
            this.originalException = e;
            this.error = e.getCause().getCause();
            this.data = this.runtimeContext.wrap(null);
        }
    }

    public DALNode getMetaDataNode() {
        return this.metaDataNode;
    }

    public DALNode getSymbolNode() {
        return this.symbolNode;
    }

    public RuntimeContextBuilder.DALRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public Data getData() {
        if (this.error != null) {
            throw this.originalException;
        }
        return this.data;
    }

    public Throwable catchError() {
        Throwable throwable = this.error;
        this.error = null;
        return throwable;
    }

    public Object callSuper() {
        return this.getRuntimeContext().fetchSuperMetaFunction(this).orElseThrow(this::noSuperError).apply(this);
    }

    public Object callSuper(Supplier<Object> supplier) {
        this.setData(() -> {
            Object newData = supplier.get();
            this.checkType(newData);
            return this.runtimeContext.wrap(newData);
        });
        return this.callSuper();
    }

    public Object callGlobal() {
        return this.getRuntimeContext().fetchGlobalMetaFunction(this).apply(this);
    }

    public Object callGlobal(Supplier<Object> supplier) {
        this.setData(() -> this.runtimeContext.wrap(supplier.get()));
        return this.callGlobal();
    }

    public MetaData newMeta(String name) {
        return new MetaData(this.metaDataNode, this.symbolNode, this.runtimeContext, this.data, this.error, this.originalException, name);
    }

    public Object callMeta(String another) {
        MetaData metaData = this.newMeta(another);
        return this.getRuntimeContext().fetchGlobalMetaFunction(metaData).apply(metaData);
    }

    public Object callMeta(String another, Supplier<Object> supplier) {
        MetaData metaData = this.newMeta(another);
        metaData.setData(() -> this.runtimeContext.wrap(supplier.get()));
        return this.getRuntimeContext().fetchGlobalMetaFunction(metaData).apply(metaData);
    }

    private void checkType(Object data) {
        Class<?> expect = this.data.getInstance().getClass();
        Class<?> actual = Objects.requireNonNull(data).getClass();
        if (actual.isAnonymousClass()) {
            actual = actual.getSuperclass();
        }
        if (!actual.equals(expect)) {
            throw new RuntimeException(String.format("Do not allow change data type in callSuper, expect %s but %s", expect.getName(), actual.getName()), this.symbolNode.getPositionBegin());
        }
    }

    private RuntimeException noSuperError() {
        return new RuntimeException(String.format("Local meta property `%s` has no super in type %s", this.symbolNode.getRootSymbolName(), this.callTypes.get(this.callTypes.size() - 1).getName()), this.symbolNode.getPositionBegin());
    }

    public void addCallType(Class<?> callType) {
        this.callTypes.add(callType);
    }

    public boolean calledBy(Class<?> type) {
        return this.callTypes.contains(type);
    }

    public boolean isInstance(Class<?> type) {
        return type.isInstance(this.data.getInstance());
    }

    public Object getName() {
        return this.name;
    }
}

