/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal;

import com.github.leeonky.dal.DAL;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.InputException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.schema.Actual;
import com.github.leeonky.dal.runtime.schema.Expect;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.InputCode;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.util.BeanClass;
import java.lang.reflect.Array;
import java.util.function.Supplier;

public class Assertions {
    private final InputCode<Object> inputCode;
    public static boolean dumpInput = true;
    private DAL dal;
    private static Supplier<DAL> dalFactory = DAL::getInstance;
    private Class<?> schema;

    public static void setDalFactory(Supplier<DAL> dalFactory) {
        Assertions.dalFactory = dalFactory;
    }

    public static void dumpInput(boolean enable) {
        dumpInput = enable;
    }

    private Assertions(InputCode<Object> input) {
        this.inputCode = input;
        this.dal = dalFactory.get();
    }

    public Assertions use(DAL dal) {
        this.dal = dal;
        return this;
    }

    public static Assertions expect(Object input) {
        return new Assertions(() -> input);
    }

    public static Assertions expectRun(InputCode<Object> supplier) {
        return new Assertions(supplier);
    }

    public Assertions should(String dalExpression) {
        return this.should("", dalExpression);
    }

    public Assertions should(String prefix, String verification) {
        String fullCode = prefix + verification;
        try {
            return this.execute(() -> this.dal.evaluate(this.inputCode, fullCode, this.schema));
        }
        catch (InterpreterException e) {
            String detailMessage = "\n" + e.show(fullCode, prefix.length()) + "\n\n" + e.getMessage();
            if (dumpInput) {
                detailMessage = detailMessage + "\n\nThe root value was: " + this.dal.getRuntimeContextBuilder().build(null).wrap(this.inputCode).dumpAll();
            }
            throw new AssertionError((Object)detailMessage);
        }
    }

    private Assertions execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (InputException e) {
            String detailMessage = "\n" + e.getMessage();
            detailMessage = detailMessage + "\n\nInput code got exception: " + this.dal.getRuntimeContextBuilder().build(null).wrap(e.getInputClause()).dumpAll();
            throw new AssertionError((Object)detailMessage);
        }
        return this;
    }

    public void exact(String verification) {
        this.should("=", verification);
    }

    public void match(String verification) {
        this.should(":", verification);
    }

    public Assertions is(Class<?> schema) {
        RuntimeContextBuilder.DALRuntimeContext context = this.dal.getRuntimeContextBuilder().build(this.inputCode, schema);
        try {
            this.schema = schema;
            return this.execute(() -> Verification.expect(new Expect((BeanClass<Object>)BeanClass.create((Class)schema), null)).verify(context, Actual.actual(context.getThis())));
        }
        catch (IllegalTypeException e) {
            String detailMessage = "\n" + e.getMessage();
            if (dumpInput) {
                detailMessage = detailMessage + "\n\nThe root value was: " + this.dal.getRuntimeContextBuilder().build(null).wrap(this.inputCode).dumpAll();
            }
            throw new AssertionError((Object)detailMessage);
        }
    }

    public Assertions is(String schema) {
        if (schema.startsWith("[") && schema.endsWith("]")) {
            return this.is(Array.newInstance(this.dal.getRuntimeContextBuilder().schemaType(schema.replace('[', ' ').replace(']', ' ').trim()).getType(), 0).getClass());
        }
        return this.is(this.dal.getRuntimeContextBuilder().schemaType(schema).getType());
    }
}

