/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.opt;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.ExecutableNode;
import com.github.leeonky.dal.ast.node.SchemaComposeNode;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.compiler.Notations;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RemarkData;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.RuntimeData;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.interpreter.Notation;
import com.github.leeonky.util.function.TriFunction;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Factory {
    public static DALOperator logical(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.SupplierSupplierData logical) {
        return new Operator(200, notation, ExpressionContextData.adapt(logical), true);
    }

    public static DALOperator plusSub(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.ObjectObjectContextObject plusSub) {
        return new Operator(300, notation, ExpressionContextData.adapt(plusSub), false);
    }

    public static DALOperator mulDiv(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData.ObjectObjectContextObject mulDiv) {
        return new Operator(400, notation, ExpressionContextData.adapt(mulDiv), false);
    }

    public static DALOperator comparator(Notation<?, ?, ?, ?, ?> notation, ExpressionContextData operation) {
        return new Operator(210, notation, operation, true);
    }

    public static DALOperator unary(final Notation<?, ?, ?, ?, ?> notation, ExpressionContextData unary) {
        return new Operator(500, notation, unary, true){

            @Override
            public String inspect(String node1, String node2) {
                return notation.getLabel() + node2;
            }
        };
    }

    public static DALOperator executable(Notation<?, ?, ?, ?, ?> notation) {
        return new DALOperator(501, notation.getLabel(), false){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((ExecutableNode)((Object)expression.right())).getValue(expression.left(), context);
            }

            @Override
            public String inspect(String node1, String node2) {
                return String.format("%s%s%s", node1, this.label, node2);
            }
        };
    }

    public static DALOperator is() {
        return new DALOperator(210, Notations.Operators.IS.getLabel(), true){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return ((SchemaComposeNode)expression.right()).verify(expression.left(), context);
            }
        };
    }

    public static DALOperator which() {
        return new DALOperator(100, Notations.Operators.WHICH.getLabel(), true){

            @Override
            public Object calculate(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                try {
                    return expression.left().evaluateData(context).execute(() -> expression.right().evaluate(context));
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException(e.getMessage(), this.getPosition());
                }
            }
        };
    }

    public static DALOperator dataRemark() {
        return new DALOperator(501, "DATA_REMARK", false){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.invokeDataRemark(new RemarkData(expression.left().evaluateData(context), expression.left(), expression.right(), context, expression.operator()));
            }

            @Override
            public String inspect(String node1, String node2) {
                return node1 + "(" + node2 + ")";
            }
        };
    }

    public static DALOperator exclamation() {
        return new DALOperator(501, "EXCLAMATION", false){

            @Override
            public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
                return context.invokeExclamations(new RuntimeData(expression.left().evaluateData(context), expression.left(), expression.right(), context, expression.operator()));
            }

            @Override
            public String inspect(String node1, String node2) {
                return node1 + node2;
            }
        };
    }

    static class Operator
    extends DALOperator {
        private final ExpressionContextData operation;

        public Operator(int precedence, Notation<?, ?, ?, ?, ?> notation, ExpressionContextData operation, boolean needInspect) {
            super(precedence, notation.getLabel(), needInspect);
            this.operation = operation;
        }

        @Override
        public Data calculateData(DALExpression expression, RuntimeContextBuilder.DALRuntimeContext context) {
            return (Data)this.operation.apply(expression, context);
        }
    }

    public static interface ExpressionContextData
    extends BiFunction<DALExpression, RuntimeContextBuilder.DALRuntimeContext, Data> {
        public static ExpressionContextData adapt(SupplierSupplierData operation) {
            return (expression, context) -> context.wrap(((Data)operation.apply(() -> expression.left().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), () -> expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context))).instance());
        }

        public static ExpressionContextData adapt(ObjectObjectContextObject operation) {
            return (expression, context) -> context.wrap(operation.apply(expression.left().evaluate((RuntimeContextBuilder.DALRuntimeContext)context), expression.right().evaluate((RuntimeContextBuilder.DALRuntimeContext)context), context));
        }

        public static ExpressionContextData adapt(DataContextData operation) {
            return (expression, context) -> (Data)operation.apply(expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), context);
        }

        public static ExpressionContextData adapt(ObjectObject operation) {
            return (expression, context) -> context.wrap(operation.apply(expression.right().evaluate((RuntimeContextBuilder.DALRuntimeContext)context)));
        }

        public static ExpressionContextData adapt(DataDataObject operation) {
            return (expression, context) -> context.wrap(operation.apply(expression.left().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context), expression.right().evaluateData((RuntimeContextBuilder.DALRuntimeContext)context)));
        }

        public static interface DataDataObject
        extends BiFunction<Data, Data, Object> {
        }

        public static interface ObjectObject
        extends Function<Object, Object> {
        }

        public static interface DataContextData
        extends BiFunction<Data, RuntimeContextBuilder.DALRuntimeContext, Data> {
        }

        public static interface ObjectObjectContextObject
        extends TriFunction<Object, Object, RuntimeContextBuilder.DALRuntimeContext, Object> {
        }

        public static interface SupplierSupplierData
        extends BiFunction<Supplier<Data>, Supplier<Data>, Data> {
        }
    }
}

