/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.runtime.CurryingMethod;
import com.github.leeonky.dal.runtime.InstanceCurryingMethod;
import com.github.leeonky.dal.runtime.InvalidPropertyException;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.StaticCurryingMethod;
import com.github.leeonky.util.function.Extension;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class CurryingMethodGroup
implements CurryingMethod {
    private final CurryingMethodGroup parent;
    private final List<InstanceCurryingMethod> curryingMethods;
    private InstanceCurryingMethod resolvedCurryingMethod;

    CurryingMethodGroup(List<InstanceCurryingMethod> curryingMethods, CurryingMethodGroup parent) {
        this.curryingMethods = curryingMethods;
        this.parent = parent;
    }

    @Override
    public CurryingMethodGroup call(Object arg) {
        return new CurryingMethodGroup(this.curryingMethods.stream().map(curryingMethod -> curryingMethod.call(arg)).collect(Collectors.toList()), this);
    }

    @Override
    public Object resolve() {
        Optional curryingMethod = Extension.getFirstPresent((Supplier[])new Supplier[]{() -> this.selectCurryingMethod(InstanceCurryingMethod::allParamsSameType), () -> this.selectCurryingMethod(InstanceCurryingMethod::allParamsBaseType), () -> this.selectCurryingMethod(InstanceCurryingMethod::allParamsConvertible)});
        return curryingMethod.isPresent() ? this.setResolveCurryingMethod((InstanceCurryingMethod)curryingMethod.get()).resolve() : this;
    }

    private InstanceCurryingMethod setResolveCurryingMethod(InstanceCurryingMethod curryingMethod) {
        if (this.parent != null) {
            this.parent.setResolveCurryingMethod(curryingMethod);
        }
        this.resolvedCurryingMethod = curryingMethod;
        return curryingMethod;
    }

    private Optional<InstanceCurryingMethod> selectCurryingMethod(Predicate<InstanceCurryingMethod> predicate) {
        List methods = this.curryingMethods.stream().filter(predicate).collect(Collectors.toList());
        if (methods.size() > 1) {
            List sameInstanceTypeMethods = methods.stream().filter(StaticCurryingMethod.class::isInstance).collect(Collectors.toList());
            return Optional.of(Extension.getFirstPresent((Supplier[])new Supplier[]{() -> this.getOnlyOne(sameInstanceTypeMethods), () -> this.getOnlyOne(sameInstanceTypeMethods.stream().filter(InstanceCurryingMethod::isSameInstanceType).collect(Collectors.toList()))}).orElseThrow(() -> new InvalidPropertyException("More than one currying method:\n" + methods.stream().map(instanceCurryingMethod -> "  " + instanceCurryingMethod.toString()).sorted().collect(Collectors.joining("\n")))));
        }
        return methods.stream().findFirst();
    }

    private Optional<InstanceCurryingMethod> getOnlyOne(List<InstanceCurryingMethod> list) {
        if (list.size() == 1) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    @Override
    public Set<Object> fetchArgRange(RuntimeContextBuilder runtimeContextBuilder) {
        return this.queryResolvedMethod().map(method -> method.fetchArgRange(runtimeContextBuilder)).orElseGet(Collections::emptySet);
    }

    private Optional<InstanceCurryingMethod> queryResolvedMethod() {
        return this.curryingMethods.stream().filter(method -> method.method.equals(this.resolvedCurryingMethod.method)).findFirst();
    }

    @Override
    public Object convertToArgType(Object obj) {
        return this.queryResolvedMethod().map(method -> method.convertToArgType(obj)).orElse(obj);
    }
}

