/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime;

import com.github.leeonky.dal.format.Formatter;
import com.github.leeonky.dal.runtime.ClassKeyMap;
import com.github.leeonky.dal.runtime.CollectionDALCollection;
import com.github.leeonky.dal.runtime.ConstructorViaSchema;
import com.github.leeonky.dal.runtime.DALCollection;
import com.github.leeonky.dal.runtime.DALCollectionFactory;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.ErrorHook;
import com.github.leeonky.dal.runtime.IllegalTypeException;
import com.github.leeonky.dal.runtime.InputException;
import com.github.leeonky.dal.runtime.InvalidPropertyException;
import com.github.leeonky.dal.runtime.JavaClassPropertyAccessor;
import com.github.leeonky.dal.runtime.MetaData;
import com.github.leeonky.dal.runtime.NameStrategy;
import com.github.leeonky.dal.runtime.PartialProperties;
import com.github.leeonky.dal.runtime.PartialPropertyStack;
import com.github.leeonky.dal.runtime.PropertyAccessor;
import com.github.leeonky.dal.runtime.RemarkData;
import com.github.leeonky.dal.runtime.Result;
import com.github.leeonky.dal.runtime.RuntimeData;
import com.github.leeonky.dal.runtime.RuntimeException;
import com.github.leeonky.dal.runtime.SchemaType;
import com.github.leeonky.dal.runtime.TextAttribute;
import com.github.leeonky.dal.runtime.TextFormatter;
import com.github.leeonky.dal.runtime.UserLiteralRule;
import com.github.leeonky.dal.runtime.checker.Checker;
import com.github.leeonky.dal.runtime.checker.CheckerSet;
import com.github.leeonky.dal.runtime.inspector.Dumper;
import com.github.leeonky.dal.runtime.inspector.DumperFactory;
import com.github.leeonky.dal.runtime.schema.Actual;
import com.github.leeonky.dal.runtime.schema.Expect;
import com.github.leeonky.dal.runtime.schema.Verification;
import com.github.leeonky.dal.type.ExtensionName;
import com.github.leeonky.dal.type.InputCode;
import com.github.leeonky.dal.type.Schema;
import com.github.leeonky.interpreter.RuntimeContext;
import com.github.leeonky.interpreter.SyntaxException;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.Classes;
import com.github.leeonky.util.CollectionHelper;
import com.github.leeonky.util.Converter;
import com.github.leeonky.util.InvocationException;
import com.github.leeonky.util.NumberType;
import com.github.leeonky.util.ThrowingSupplier;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuntimeContextBuilder {
    private final ClassKeyMap<PropertyAccessor<Object>> propertyAccessors = new ClassKeyMap();
    private final ClassKeyMap<DALCollectionFactory<Object, Object>> dALCollectionFactories = new ClassKeyMap();
    private final ClassKeyMap<Function<Object, Object>> objectImplicitMapper = new ClassKeyMap();
    private final Map<String, ConstructorViaSchema> valueConstructors = new LinkedHashMap<String, ConstructorViaSchema>();
    private final Map<String, BeanClass<?>> schemas = new HashMap();
    private final Set<Method> extensionMethods = new HashSet<Method>();
    private final Map<Object, Function<MetaData, Object>> metaProperties = new HashMap<Object, Function<MetaData, Object>>();
    private final ClassKeyMap<Function<RemarkData, Data>> remarks = new ClassKeyMap();
    private final ClassKeyMap<Function<RuntimeData, Data>> exclamations = new ClassKeyMap();
    private final List<UserLiteralRule> userDefinedLiterals = new ArrayList<UserLiteralRule>();
    private final NumberType numberType = new NumberType();
    private final Map<Method, BiFunction<Object, List<Object>, List<Object>>> curryingMethodArgRanges = new HashMap<Method, BiFunction<Object, List<Object>, List<Object>>>();
    private final Map<String, TextFormatter<?, ?>> textFormatterMap = new LinkedHashMap();
    private Converter converter = Converter.getInstance();
    private final ClassKeyMap<DumperFactory> dumperFactories = new ClassKeyMap();
    private final CheckerSet checkerSetForMatching = new CheckerSet(CheckerSet::defaultMatching);
    private final CheckerSet checkerSetForEqualing = new CheckerSet(CheckerSet::defaultEqualing);
    private int maxDumpingLineSize = 2000;
    private int maxDumpingObjectSize = 255;
    private ErrorHook errorHook = (i, code, e) -> {};
    private final Map<Class<?>, Map<Object, Function<MetaData, Object>>> localMetaProperties = new TreeMap(Classes::compareByExtends);

    public RuntimeContextBuilder registerMetaProperty(Object property, Function<MetaData, Object> function) {
        this.metaProperties.put(property, function);
        return this;
    }

    public RuntimeContextBuilder registerTextFormatter(String name, TextFormatter<?, ?> formatter) {
        this.textFormatterMap.put(name, formatter);
        return this;
    }

    public DALRuntimeContext build(Object inputValue) {
        return this.build(() -> inputValue, null);
    }

    public DALRuntimeContext build(InputCode<?> inputSupplier) {
        return this.build(inputSupplier, null);
    }

    public DALRuntimeContext build(InputCode<?> inputSupplier, Class<?> rootSchema) {
        if (inputSupplier == null) {
            return new DALRuntimeContext(() -> null, rootSchema);
        }
        return new DALRuntimeContext(inputSupplier, rootSchema);
    }

    public RuntimeContextBuilder registerValueFormat(Formatter<?, ?> formatter) {
        return this.registerValueFormat(formatter.getFormatterName(), formatter);
    }

    public RuntimeContextBuilder registerValueFormat(String name, Formatter<?, ?> formatter) {
        this.valueConstructors.put(name, (o, c) -> formatter.transform(o.instance()));
        return this;
    }

    public RuntimeContextBuilder registerSchema(Class<? extends Schema> schema) {
        return this.registerSchema(NameStrategy.SIMPLE_NAME, schema);
    }

    public RuntimeContextBuilder registerSchema(String name, Class<? extends Schema> schema) {
        this.schemas.put(name, BeanClass.create(schema));
        return this.registerSchema(name, (Data data, DALRuntimeContext context) -> Verification.expect(new Expect((BeanClass<Object>)BeanClass.create((Class)schema), null)).verify((DALRuntimeContext)context, Actual.actual(data)));
    }

    public RuntimeContextBuilder registerSchema(String name, BiFunction<Data, DALRuntimeContext, Boolean> predicate) {
        this.valueConstructors.put(name, (o, context) -> {
            if (((Boolean)predicate.apply((Data)o, (DALRuntimeContext)context)).booleanValue()) {
                return o.instance();
            }
            throw new IllegalTypeException();
        });
        return this;
    }

    public <T> RuntimeContextBuilder registerPropertyAccessor(Class<T> type, PropertyAccessor<? extends T> propertyAccessor) {
        this.propertyAccessors.put(type, propertyAccessor);
        return this;
    }

    public <T, E> RuntimeContextBuilder registerDALCollectionFactory(Class<T> type, DALCollectionFactory<T, E> DALCollectionFactory2) {
        this.dALCollectionFactories.put(type, DALCollectionFactory2);
        return this;
    }

    public RuntimeContextBuilder registerSchema(NameStrategy nameStrategy, Class<? extends Schema> schema) {
        return this.registerSchema(nameStrategy.toName(schema), schema);
    }

    public RuntimeContextBuilder registerStaticMethodExtension(Class<?> staticMethodExtensionClass) {
        Stream.of(staticMethodExtensionClass.getMethods()).filter(method -> method.getParameterCount() >= 1 && (8 & method.getModifiers()) != 0).forEach(this.extensionMethods::add);
        return this;
    }

    public <T> RuntimeContextBuilder registerImplicitData(Class<T> type, Function<T, Object> mapper) {
        this.objectImplicitMapper.put(type, mapper);
        return this;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public RuntimeContextBuilder setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public RuntimeContextBuilder registerUserDefinedLiterals(UserLiteralRule rule) {
        this.userDefinedLiterals.add(rule);
        return this;
    }

    public RuntimeContextBuilder registerCurryingMethodAvailableParameters(Method method, BiFunction<Object, List<Object>, List<Object>> range) {
        this.curryingMethodArgRanges.put(method, range);
        return this;
    }

    private Set<Method> methodToCurrying(Class<?> type, Object methodName) {
        return Stream.of(Arrays.stream(type.getMethods()).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> method.getName().equals(methodName)), this.staticMethodsToCurrying(type, methodName, Object::equals), this.staticMethodsToCurrying(type, methodName, Class::isAssignableFrom)).flatMap(Function.identity()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<Method> staticMethodsToCurrying(Class<?> type, Object property, BiPredicate<Class<?>, Class<?>> condition) {
        return this.extensionMethods.stream().filter(method -> RuntimeContextBuilder.staticExtensionMethodName(method).equals(property)).filter(method -> condition.test(method.getParameters()[0].getType(), type));
    }

    private static String staticExtensionMethodName(Method method) {
        ExtensionName extensionName = method.getAnnotation(ExtensionName.class);
        return extensionName != null ? extensionName.value() : method.getName();
    }

    BiFunction<Object, List<Object>, List<Object>> fetchCurryingMethodArgRange(Method method) {
        return this.curryingMethodArgRanges.get(method);
    }

    public CheckerSet checkerSetForMatching() {
        return this.checkerSetForMatching;
    }

    public CheckerSet checkerSetForEqualing() {
        return this.checkerSetForEqualing;
    }

    public RuntimeContextBuilder registerDumper(Class<?> type, DumperFactory factory) {
        this.dumperFactories.put(type, factory);
        return this;
    }

    public void setMaxDumpingLineSize(int size) {
        this.maxDumpingLineSize = size;
    }

    public <T> RuntimeContextBuilder registerErrorHook(ErrorHook hook) {
        this.errorHook = Objects.requireNonNull(hook);
        return this;
    }

    public void mergeTextFormatter(String name, String other, String ... others) {
        TextFormatter<?, ?> formatter = this.textFormatterMap.get(other);
        for (String o : others) {
            formatter = formatter.merge(this.textFormatterMap.get(o));
        }
        this.registerTextFormatter(name, this.delegateFormatter(formatter, "Merged from " + other + " " + String.join((CharSequence)" ", others)));
    }

    private TextFormatter delegateFormatter(final TextFormatter formatter, final String description) {
        return new TextFormatter(){

            protected Object format(Object content, TextAttribute attribute, DALRuntimeContext context) {
                return formatter.format(content, attribute, context);
            }

            @Override
            protected TextAttribute attribute(TextAttribute attribute) {
                return formatter.attribute(attribute);
            }

            public Class<?> returnType() {
                return formatter.returnType();
            }

            public Class<?> acceptType() {
                return formatter.acceptType();
            }

            @Override
            public String description() {
                return description;
            }
        };
    }

    public RuntimeContextBuilder registerMetaProperty(Class<?> type, Object name, Function<MetaData, Object> function) {
        this.localMetaProperties.computeIfAbsent(type, k -> new HashMap()).put(name, function);
        return this;
    }

    public RuntimeContextBuilder registerDataRemark(Class<?> type, Function<RemarkData, Data> action) {
        this.remarks.put(type, action);
        return this;
    }

    public RuntimeContextBuilder registerExclamation(Class<?> type, Function<RuntimeData, Data> action) {
        this.exclamations.put(type, action);
        return this;
    }

    public BeanClass<?> schemaType(String schema) {
        BeanClass<?> type = this.schemas.get(schema);
        if (type != null) {
            return type;
        }
        throw new IllegalStateException(String.format("Unknown schema '%s'", schema));
    }

    public void setMaxDumpingObjectSize(int maxDumpingObjectSize) {
        this.maxDumpingObjectSize = maxDumpingObjectSize;
    }

    public class DALRuntimeContext
    implements RuntimeContext {
        private final LinkedList<Data> stack = new LinkedList();
        private final Map<Data, PartialPropertyStack> partialPropertyStacks;
        private final Data inputValue;
        private final Throwable inputError;

        public DALRuntimeContext(InputCode<?> supplier, Class<?> schema) {
            Throwable error;
            Data value;
            BeanClass rootSchema = null;
            if (schema != null) {
                rootSchema = BeanClass.create(schema);
            }
            try {
                value = this.wrap(supplier.get(), rootSchema);
                error = null;
            }
            catch (Throwable e) {
                value = this.wrap(null);
                error = e;
            }
            this.inputError = error;
            this.inputValue = value;
            this.partialPropertyStacks = new HashMap<Data, PartialPropertyStack>();
        }

        public Data getThis() {
            if (this.stack.isEmpty()) {
                if (this.inputError != null) {
                    throw new InputException(this.inputError);
                }
                return this.inputValue;
            }
            return this.stack.getFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T pushAndExecute(Data data, Supplier<T> supplier) {
            try {
                this.stack.push(data);
                T t = supplier.get();
                return t;
            }
            finally {
                this.stack.pop();
            }
        }

        public Optional<ConstructorViaSchema> searchValueConstructor(String type) {
            return Optional.ofNullable(RuntimeContextBuilder.this.valueConstructors.get(type));
        }

        public Set<Object> findPropertyReaderNames(Object instance) {
            return ((PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(instance)).getPropertyNames(instance);
        }

        public Boolean isNull(Object instance) {
            return RuntimeContextBuilder.this.propertyAccessors.tryGetData(instance).map(f -> f.isNull(instance)).orElseGet(() -> Objects.equals(instance, null));
        }

        public Object getPropertyValue(Data data, Object property) {
            PropertyAccessor propertyAccessor = (PropertyAccessor)RuntimeContextBuilder.this.propertyAccessors.getData(data.instance());
            try {
                return propertyAccessor.getValueByData(data, property);
            }
            catch (InvalidPropertyException e) {
                return data.currying(property).orElseThrow(() -> e).resolve();
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationException((Throwable)e);
            }
        }

        public DALCollection<Object> createCollection(Object instance) {
            return RuntimeContextBuilder.this.dALCollectionFactories.tryGetData(instance).map(factory -> factory.create(instance)).orElseGet(() -> new CollectionDALCollection(CollectionHelper.toStream((Object)instance).collect(Collectors.toList())));
        }

        public boolean isRegisteredList(Object instance) {
            return RuntimeContextBuilder.this.dALCollectionFactories.tryGetData(instance).map(f -> f.isList(instance)).orElse(false);
        }

        public Converter getConverter() {
            return RuntimeContextBuilder.this.converter;
        }

        public Data wrap(Object instance) {
            return this.wrap(instance, null);
        }

        public Data wrap(Object instance, String schema, boolean isList) {
            BeanClass schemaType = (BeanClass)RuntimeContextBuilder.this.schemas.get(schema);
            if (isList && schemaType != null) {
                schemaType = BeanClass.create(Array.newInstance(schemaType.getType(), 0).getClass());
            }
            return this.wrap(instance, schemaType);
        }

        public Data wrap(Object instance, BeanClass<?> schemaType) {
            return new Data(instance, this, SchemaType.create(schemaType));
        }

        public <T> DALRuntimeContext registerPropertyAccessor(T instance) {
            if (!Objects.equals(instance, null) && !RuntimeContextBuilder.this.propertyAccessors.containsType(instance)) {
                RuntimeContextBuilder.this.propertyAccessors.put(BeanClass.getClass(instance), new JavaClassPropertyAccessor(BeanClass.createFrom(instance)));
            }
            return this;
        }

        public Optional<Result> takeUserDefinedLiteral(String token) {
            return RuntimeContextBuilder.this.userDefinedLiterals.stream().map(userLiteralRule -> userLiteralRule.compile(token)).filter(Result::hasResult).findFirst();
        }

        public void appendPartialPropertyReference(Data data, Object symbol) {
            this.fetchPartialProperties(data).map(partialProperties -> partialProperties.appendPartialProperties(symbol));
        }

        private Optional<PartialProperties> fetchPartialProperties(Data data) {
            return this.partialPropertyStacks.values().stream().map(partialPropertyStack -> partialPropertyStack.fetchPartialProperties(data)).filter(Objects::nonNull).findFirst();
        }

        public void initPartialPropertyStack(Data instance, Object prefix, Data partial) {
            this.partialPropertyStacks.computeIfAbsent(instance, _key -> this.fetchPartialProperties(instance).map(partialProperties -> partialProperties.partialPropertyStack).orElseGet(PartialPropertyStack::new)).setupPartialProperties(prefix, partial);
        }

        public Set<String> collectPartialProperties(Data instance) {
            PartialPropertyStack partialPropertyStack = this.partialPropertyStacks.get(instance);
            if (partialPropertyStack != null) {
                return partialPropertyStack.collectPartialProperties(instance);
            }
            return this.fetchPartialProperties(instance).map(partialProperties -> partialProperties.partialPropertyStack.collectPartialProperties(instance)).orElse(Collections.emptySet());
        }

        public NumberType getNumberType() {
            return RuntimeContextBuilder.this.numberType;
        }

        public Optional<Object> getImplicitObject(Object obj) {
            return RuntimeContextBuilder.this.objectImplicitMapper.tryGetData(obj).map(mapper -> mapper.apply(obj));
        }

        public Set<Method> methodToCurrying(Class<?> type, Object methodName) {
            return RuntimeContextBuilder.this.methodToCurrying(type, methodName);
        }

        public Function<MetaData, Object> fetchGlobalMetaFunction(MetaData metaData) {
            return RuntimeContextBuilder.this.metaProperties.computeIfAbsent(metaData.name(), k -> {
                throw new RuntimeException(String.format("Meta property `%s` not found", metaData.name()), metaData.operandNode().getPositionBegin());
            });
        }

        private Optional<Function<MetaData, Object>> fetchLocalMetaFunction(MetaData metaData) {
            return this.metaFunctionsByType(metaData).map(e -> {
                metaData.addCallType((Class)e.getKey());
                return (Function)((Map)e.getValue()).get(metaData.name());
            }).filter(Objects::nonNull).findFirst();
        }

        public Optional<Function<MetaData, Object>> fetchSuperMetaFunction(MetaData metaData) {
            return this.metaFunctionsByType(metaData).filter(e -> !metaData.calledBy((Class)e.getKey())).map(e -> {
                metaData.addCallType((Class)e.getKey());
                return (Function)((Map)e.getValue()).get(metaData.name());
            }).filter(Objects::nonNull).findFirst();
        }

        private Stream<Map.Entry<Class<?>, Map<Object, Function<MetaData, Object>>>> metaFunctionsByType(MetaData metaData) {
            return RuntimeContextBuilder.this.localMetaProperties.entrySet().stream().filter(e -> metaData.isInstance((Class)e.getKey()));
        }

        public <T> TextFormatter<String, T> fetchFormatter(String name, int position) {
            return RuntimeContextBuilder.this.textFormatterMap.computeIfAbsent(name, attribute -> {
                throw new SyntaxException(String.format("Invalid text formatter `%s`, all supported formatters are:\n%s", attribute, RuntimeContextBuilder.this.textFormatterMap.entrySet().stream().map(e -> String.format("  %s:\n    %s", e.getKey(), ((TextFormatter)e.getValue()).fullDescription())).collect(Collectors.joining("\n"))), position);
            });
        }

        public Checker fetchEqualsChecker(Data expected, Data actual) {
            return RuntimeContextBuilder.this.checkerSetForEqualing.fetch(expected, actual);
        }

        public Checker fetchMatchingChecker(Data expected, Data actual) {
            return RuntimeContextBuilder.this.checkerSetForMatching.fetch(expected, actual);
        }

        public Dumper fetchDumper(Data data) {
            return RuntimeContextBuilder.this.dumperFactories.tryGetData(data.instance()).map(factory -> (Dumper)factory.apply(data)).orElseGet(() -> {
                if (data.isNull()) {
                    return (_data, dumpingContext) -> dumpingContext.append("null");
                }
                if (data.isList()) {
                    return Dumper.LIST_DUMPER;
                }
                return Dumper.MAP_DUMPER;
            });
        }

        public int maxDumpingLineCount() {
            return RuntimeContextBuilder.this.maxDumpingLineSize;
        }

        public int maxDumpingObjectSize() {
            return RuntimeContextBuilder.this.maxDumpingObjectSize;
        }

        public void hookError(ThrowingSupplier<Object> input, String expression, Throwable error) {
            RuntimeContextBuilder.this.errorHook.handle(input, expression, error);
        }

        public Object invokeMetaProperty(MetaData metaData) {
            return this.fetchLocalMetaFunction(metaData).orElseGet(() -> this.fetchGlobalMetaFunction(metaData)).apply(metaData);
        }

        public Data invokeDataRemark(RemarkData remarkData) {
            Object instance = remarkData.data().instance();
            return (Data)((Function)RuntimeContextBuilder.this.remarks.tryGetData(instance).orElseThrow(() -> new RuntimeException("Not implement operator () of " + Classes.getClassName((Object)instance), remarkData.operator().getPosition()))).apply(remarkData);
        }

        public Data invokeExclamations(RuntimeData runtimeData) {
            Object instance = runtimeData.data().instance();
            return (Data)((Function)RuntimeContextBuilder.this.exclamations.tryGetData(instance).orElseThrow(() -> new RuntimeException(String.format("Not implement operator %s of %s", runtimeData.operandNode().inspect(), Classes.getClassName((Object)instance)), runtimeData.operandNode().getPositionBegin()))).apply(runtimeData);
        }
    }
}

