/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.inspector;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.inspector.Dumper;
import com.github.leeonky.dal.runtime.inspector.DumpingBuffer;
import com.github.leeonky.util.Classes;
import java.util.Map;
import java.util.Set;

public class MapDumper
implements Dumper.Cacheable {
    @Override
    public void cachedInspect(Data data, DumpingBuffer context) {
        this.dumpType(data, context);
        this.dumpBody(data, context);
    }

    private void dumpBody(Data data, DumpingBuffer dumpingBuffer) {
        DumpingBuffer indentContext = dumpingBuffer.append("{").indent();
        this.getFieldNames(data).forEach(fieldName -> {
            this.dumpField(data, fieldName, indentContext.sub(fieldName).newLine());
            indentContext.appendThen(",");
        });
        dumpingBuffer.optionalNewLine().append("}");
    }

    protected void dumpField(Data data, Object field, DumpingBuffer context) {
        Data value;
        context.append(this.key(field)).append(": ");
        try {
            value = data.getValue(field);
        }
        catch (Exception e) {
            context.append("*throw* " + e);
            return;
        }
        context.dumpValue(value);
    }

    protected String key(Object o) {
        return String.valueOf(o);
    }

    protected Set<Object> getFieldNames(Data data) {
        return data.fieldNames();
    }

    protected void dumpType(Data data, DumpingBuffer dumpingBuffer) {
        if (!(data.instance() instanceof Map)) {
            dumpingBuffer.append(Classes.getClassName((Object)data.instance())).appendThen(" ");
        }
    }
}

