/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node;

import com.github.leeonky.dal.ast.node.DALExpression;
import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.table.Body;
import com.github.leeonky.dal.ast.node.table.RowType;
import com.github.leeonky.dal.ast.opt.DALOperator;
import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.interpreter.InterpreterException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupExpression
extends DALNode {
    private final List<DALNode> group = new ArrayList<DALNode>();
    final List<DALNode> expressions = new ArrayList<DALNode>();
    private final String inspect;

    public GroupExpression(List<DALNode> group) {
        this.group.addAll(group);
        this.expressions.addAll(group);
        this.inspect = this.group.stream().map(DALNode::inspect).collect(Collectors.joining(", ", "<<", ">>"));
    }

    public GroupExpression(List<DALNode> group, List<DALNode> expressions, String inspect) {
        this.group.addAll(group);
        this.expressions.addAll(expressions);
        this.inspect = inspect;
    }

    @Override
    public Object evaluate(RuntimeContextBuilder.DALRuntimeContext context) {
        Object result = null;
        for (int i = 0; i < this.expressions.size(); ++i) {
            result = this.evaluateExpression(context, this.expressions.get(i), i);
        }
        return result;
    }

    private Object evaluateExpression(RuntimeContextBuilder.DALRuntimeContext context, DALNode expression, int index) {
        try {
            return expression.evaluate(context);
        }
        catch (InterpreterException e) {
            throw e.multiPosition(this.group.get(index).getOperandPosition(), InterpreterException.Position.Type.CHAR);
        }
    }

    @Override
    public String inspect() {
        return this.inspect;
    }

    public DALNode append(DALOperator operator, DALNode right) {
        return new GroupExpression(this.group, this.expressions.stream().map(e -> DALExpression.expression(e, operator, right)).collect(Collectors.toList()), operator.inspect(this.inspect, right.inspect()));
    }

    public DALNode insert(DALNode left, DALOperator operator) {
        return new GroupExpression(this.group, this.expressions.stream().map(e -> DALExpression.expression(left, operator, e)).collect(Collectors.toList()), operator.inspect(left.inspect(), this.inspect));
    }

    @Override
    public Stream<Object> collectFields(Data data) {
        return this.expressions.stream().map(e -> data.firstFieldFromAlias(e.getRootSymbolName()));
    }

    @Override
    public RowType guessTableHeaderType() {
        RowType rowType = Body.EMPTY_TABLE_ROW_TYPE;
        for (DALNode expression : this.expressions) {
            rowType = rowType.merge(expression.guessTableHeaderType());
        }
        return rowType;
    }

    @Override
    public boolean needPrefixBlankWarningCheck() {
        return true;
    }
}

