/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.ast.node.table;

import com.github.leeonky.dal.ast.node.DALNode;
import com.github.leeonky.dal.ast.node.TableNode;
import com.github.leeonky.dal.ast.node.table.RowHeader;
import com.github.leeonky.dal.ast.node.table.TransposedRow;
import com.github.leeonky.interpreter.InterpreterException;
import com.github.leeonky.interpreter.SyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TransposedRowHeaderRow
extends DALNode {
    private final List<RowHeader> rowHeaders;

    public TransposedRowHeaderRow(List<DALNode> rowHeaders) {
        this.rowHeaders = rowHeaders.stream().map(RowHeader.class::cast).collect(Collectors.toList());
        if (!rowHeaders.isEmpty()) {
            this.setPositionBegin(rowHeaders.get(rowHeaders.size() - 1).getPositionBegin());
        }
    }

    @Override
    public String inspect() {
        return "| >> " + TableNode.printLine(this.rowHeaders) + "\n";
    }

    public RowHeader getRowHeader(int i) {
        if (i >= this.rowHeaders.size()) {
            return new RowHeader(Optional.empty(), Optional.empty(), Optional.empty());
        }
        return this.rowHeaders.get(i);
    }

    public void checkSize(TransposedRow row) {
        if (row.cellCount() != this.rowHeaders.size()) {
            throw new SyntaxException("Different cell size", this.getPositionBegin(), InterpreterException.Position.Type.ROW);
        }
    }
}

