/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.dal.runtime.checker;

import com.github.leeonky.dal.runtime.Data;
import com.github.leeonky.dal.runtime.RuntimeContextBuilder;
import com.github.leeonky.dal.runtime.checker.CheckingContext;
import com.github.leeonky.dal.runtime.checker.EqualsChecker;
import com.github.leeonky.dal.runtime.checker.MatchesChecker;
import java.util.function.Function;

public interface Checker {
    public static final Checker MATCH_NULL_CHECKER = CheckingContext::messageMatch;
    public static final Checker EQUALS_CHECKER = new EqualsChecker();
    public static final Checker MATCHES_CHECKER = new MatchesChecker();

    public static Checker forceFailed(final Function<CheckingContext, String> message) {
        return new Checker(){

            @Override
            public boolean failed(CheckingContext checkingContext) {
                return true;
            }

            @Override
            public String message(CheckingContext checkingContext) {
                return (String)message.apply(checkingContext);
            }
        };
    }

    default public boolean failed(CheckingContext checkingContext) {
        return checkingContext.objectNotEquals();
    }

    public String message(CheckingContext var1);

    default public Data transformActual(Data actual, Data expected, RuntimeContextBuilder.DALRuntimeContext context) {
        return actual;
    }

    default public Data transformExpected(Data expected, RuntimeContextBuilder.DALRuntimeContext context) {
        return expected;
    }

    default public Data verify(CheckingContext checkingContext) {
        if (this.failed(checkingContext)) {
            throw new AssertionError((Object)this.message(checkingContext));
        }
        return checkingContext.getOriginalActual();
    }
}

