/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanFactory;
import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.DataRepository;
import com.github.leeonky.javabuilder.DefaultBeanFactory;
import com.github.leeonky.javabuilder.DefaultBuilder;
import com.github.leeonky.javabuilder.DefaultDataRepository;
import com.github.leeonky.javabuilder.DefinitionFactory;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactoryDefinition;
import com.github.leeonky.javabuilder.ObjectFactory;
import com.github.leeonky.javabuilder.PropertyBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FactorySet {
    private final Map<Class<?>, Integer> sequences = new HashMap();
    private final PropertyBuilder propertyBuilder = PropertyBuilder.createDefaultPropertyBuilder();
    private final DataRepository dataRepository;
    private final Map<Class, Factory> factories = new HashMap<Class, Factory>();
    private final Map<Class, Factory> factoryDefinitions = new HashMap<Class, Factory>();
    private final Map<String, Factory> aliases = new HashMap<String, Factory>();

    public FactorySet(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
    }

    public FactorySet() {
        this(new DefaultDataRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeSequence(Class<?> type) {
        Class<Factory> clazz = Factory.class;
        synchronized (Factory.class) {
            int sequence = this.sequences.getOrDefault(type, 0) + 1;
            this.sequences.put(type, sequence);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sequence;
        }
    }

    public PropertyBuilder getPropertyBuilder() {
        return this.propertyBuilder;
    }

    public DataRepository getDataRepository() {
        return this.dataRepository;
    }

    public <T> Factory<T> onBuild(Class<T> type, Consumer<T> consumer) {
        return this.onBuild(type, (T obj, BuildContext<T> buildContext) -> consumer.accept(obj));
    }

    public <T> Factory<T> onBuild(Class<T> type, BiConsumer<T, BuildContext<T>> consumer) {
        BeanFactory<T> beanFactory = new BeanFactory<T>(this, type, consumer);
        this.factories.put(type, beanFactory);
        return beanFactory;
    }

    public <T> Factory<T> register(Class<T> type, Supplier<T> supplier) {
        return this.register(type, (BuildContext<T> buildContext) -> supplier.get());
    }

    public <T> Factory<T> register(Class<T> type, Function<BuildContext<T>, T> supplier) {
        ObjectFactory<T> objectFactory = new ObjectFactory<T>(this, type, supplier);
        this.factories.put(type, objectFactory);
        return objectFactory;
    }

    public <T> Factory<T> factory(Class<T> type, String extend) {
        Factory<T> factory = this.factory(type);
        if (extend != null) {
            factory = factory.query(extend);
        }
        return factory;
    }

    public <T> Factory<T> factory(Class<T> type) {
        return this.factories.computeIfAbsent(type, k -> new DefaultBeanFactory(type, this));
    }

    public <T> Factory<T> factory(String alias) {
        Factory factory = this.aliases.get(alias);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("There is no factory for alias [%s]", alias));
        }
        return factory;
    }

    public <T> Builder<T> type(Class<T> type) {
        return new DefaultBuilder<T>(this, this.factory(type));
    }

    public <T> Builder<T> type(Class<T> type, String extend) {
        return new DefaultBuilder<T>(this, this.factory(type, extend));
    }

    public <T> Builder<T> toBuild(String alias) {
        Factory factory = this.aliases.get(alias);
        if (factory == null) {
            throw new IllegalArgumentException("Factory alias '" + alias + "' does not exist");
        }
        return new DefaultBuilder(this, factory);
    }

    public boolean hasAlias(String alias) {
        return this.aliases.containsKey(alias);
    }

    public <T> void aliasFactory(String alias, Factory<T> factory) {
        if (this.aliases.containsKey(alias)) {
            throw new IllegalArgumentException("Factory alias '" + alias + "' already exists");
        }
        this.aliases.put(alias, factory);
    }

    public <T> Factory<T> onBuild(FactoryDefinition<T> factoryDefinition) {
        DefinitionFactory<T> definitionFactory = new DefinitionFactory<T>(this, factoryDefinition);
        this.factoryDefinitions.put(factoryDefinition.getClass(), definitionFactory);
        return definitionFactory;
    }

    public <T> Builder<T> toBuild(Class<? extends FactoryDefinition<T>> factoryDefinitionClass) {
        Factory factory = this.factoryDefinitions.get(factoryDefinitionClass);
        if (factory == null) {
            throw new IllegalArgumentException("FactoryDefinition '" + factoryDefinitionClass.getName() + "' does not exist");
        }
        return new DefaultBuilder(this, factory);
    }
}

