/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.ExtendedFactory;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.TriConsumer;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFactory<T>
implements Factory<T> {
    private final Class<T> type;
    private Map<String, Factory> subFactories = new HashMap<String, Factory>();
    private int sequence = 0;

    public AbstractFactory(Class<T> type) {
        this.type = type;
    }

    @Override
    public int getSequence() {
        return ++this.sequence;
    }

    @Override
    public Factory<T> extend(String name, TriConsumer<T, Integer, Map<String, Object>> consumer) {
        this.extendInner(name, consumer);
        return this;
    }

    private void extendInner(String name, TriConsumer<T, Integer, Map<String, Object>> consumer) {
        String[] names = name.split("\\.", 2);
        if (names.length == 1) {
            ExtendedFactory<T> extendedFactory = new ExtendedFactory<T>(this, consumer);
            this.subFactories.put(name, extendedFactory);
        } else {
            this.query(names[0]).extend(names[1], consumer);
        }
    }

    @Override
    public Factory<T> query(String extend) {
        String[] names = extend.split("\\.", 2);
        Factory factory = this.subFactories.get(names[0]);
        if (factory == null) {
            throw new NoFactoryException(extend, this.getType());
        }
        if (names.length == 1) {
            return factory;
        }
        try {
            return factory.query(names[1]);
        }
        catch (NoFactoryException e) {
            throw new NoFactoryException(extend, this.getType());
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    static class NoFactoryException
    extends RuntimeException {
        NoFactoryException(String extend, Class<?> type) {
            super("Factory[" + extend + "] for " + type.getName() + " dose not exist");
        }
    }
}

