/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanFactory;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.Converter;
import com.github.leeonky.javabuilder.DefaultBeanFactory;
import com.github.leeonky.javabuilder.DefaultBuilder;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.ObjectFactory;
import com.github.leeonky.javabuilder.PropertyBuilder;
import com.github.leeonky.javabuilder.TriConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FactorySet {
    private Map<Class, Factory> factories = new HashMap<Class, Factory>();
    private Consumer<Converter> converterRegister = c -> {};
    private Consumer<PropertyBuilder> propertyRegister = c -> {};

    public <T> Builder<T> type(Class<T> type) {
        return new DefaultBuilder(this.queryFactory(type), this.converterRegister);
    }

    private <T> Factory queryFactory(Class<T> type, String extend) {
        return this.queryFactory(type).query(extend);
    }

    private <T> Factory queryFactory(Class<T> type) {
        return this.factories.computeIfAbsent(type, k -> new DefaultBeanFactory(type, this.propertyRegister));
    }

    public <T> Builder<T> type(Class<T> type, String extend) {
        return new DefaultBuilder(this.queryFactory(type, extend), this.converterRegister);
    }

    public <T> Factory<T> onBuild(Class<T> type, Consumer<T> consumer) {
        return this.onBuild(type, (T obj, Integer seq) -> consumer.accept(obj));
    }

    public <T> Factory<T> onBuild(Class<T> type, BiConsumer<T, Integer> consumer) {
        return this.onBuild(type, (T obj, Integer seq, Map<String, ?> params) -> consumer.accept((Object)obj, (Integer)seq));
    }

    public <T> Factory<T> onBuild(Class<T> type, TriConsumer<T, Integer, Map<String, ?>> consumer) {
        BeanFactory<T> beanFactory = new BeanFactory<T>(type, consumer);
        this.factories.put(type, beanFactory);
        return beanFactory;
    }

    public <T> Factory<T> register(Class<T> type, Supplier<T> supplier) {
        return this.register(type, (Integer seq, Map<String, ?> params) -> supplier.get());
    }

    public <T> Factory<T> register(Class<T> type, Function<Integer, T> supplier) {
        return this.register(type, (Integer seq, Map<String, ?> params) -> supplier.apply((Integer)seq));
    }

    public <T> Factory<T> register(Class<T> type, BiFunction<Integer, Map<String, ?>, T> supplier) {
        ObjectFactory<T> objectFactory = new ObjectFactory<T>(type, supplier);
        this.factories.put(type, objectFactory);
        return objectFactory;
    }

    public FactorySet registerConverter(Consumer<Converter> register) {
        this.converterRegister = register;
        return this;
    }

    public FactorySet registerPropertyBuilder(Consumer<PropertyBuilder> register) {
        this.propertyRegister = register;
        return this;
    }
}

