/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BuildContext;
import com.github.leeonky.javabuilder.TriFunction;
import com.github.leeonky.javabuilder.TypeHandler;
import com.github.leeonky.util.PropertyWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PropertyBuilder {
    public static final LocalDate LOCAL_DATE_START = LocalDate.parse("1996-01-23");
    public static final LocalDateTime LOCAL_DATE_TIME_START = LocalDateTime.parse("1996-01-23T00:00:00");
    private static final LocalTime LOCAL_TIME_START = LocalTime.parse("00:00:00");
    private static final Instant INSTANT_START = Instant.parse("1996-01-23T00:00:00Z");
    private List<TypeHandler<TriFunction>> setters = new ArrayList<TypeHandler<TriFunction>>();
    private List<Predicate> skipper = new ArrayList<Predicate>();
    private Map<Predicate, TriFunction> propertyBuilders = new LinkedHashMap<Predicate, TriFunction>();

    public static PropertyBuilder createDefaultPropertyBuilder() {
        return new PropertyBuilder().registerFromType(String.class, (c, p, buildContext) -> p.getName() + buildContext.getSequence()).registerFromType(Long.TYPE, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Integer.TYPE, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Short.TYPE, (c, p, buildContext) -> (short)buildContext.getSequence()).registerFromType(Byte.TYPE, (c, p, buildContext) -> (byte)buildContext.getSequence()).registerFromType(Double.TYPE, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Float.TYPE, (c, p, buildContext) -> Float.valueOf(buildContext.getSequence())).registerFromType(Boolean.TYPE, (c, p, buildContext) -> buildContext.getSequence() % 2 != 0).registerFromType(Long.class, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Integer.class, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Short.class, (c, p, buildContext) -> (short)buildContext.getSequence()).registerFromType(Byte.class, (c, p, buildContext) -> (byte)buildContext.getSequence()).registerFromType(Double.class, (c, p, buildContext) -> buildContext.getSequence()).registerFromType(Float.class, (c, p, buildContext) -> Float.valueOf(buildContext.getSequence())).registerFromType(Boolean.class, (c, p, buildContext) -> buildContext.getSequence() % 2 != 0).registerFromType(BigInteger.class, (c, p, buildContext) -> BigInteger.valueOf(buildContext.getSequence())).registerFromType(BigDecimal.class, (c, p, buildContext) -> BigDecimal.valueOf(buildContext.getSequence())).registerFromType(UUID.class, (c, p, buildContext) -> UUID.fromString(String.format("00000000-0000-0000-0000-%012d", buildContext.getSequence()))).registerFromType(Instant.class, (c, p, buildContext) -> INSTANT_START.plusSeconds(buildContext.getSequence())).registerFromType(Date.class, (c, p, buildContext) -> Date.from(INSTANT_START.plus((long)buildContext.getSequence(), ChronoUnit.DAYS))).registerFromType(LocalTime.class, (c, p, buildContext) -> LOCAL_TIME_START.plusSeconds(buildContext.getSequence())).registerFromType(LocalDate.class, (c, p, buildContext) -> LOCAL_DATE_START.plusDays(buildContext.getSequence())).registerFromType(LocalDateTime.class, (c, p, buildContext) -> LOCAL_DATE_TIME_START.plusSeconds(buildContext.getSequence())).registerFromType(OffsetDateTime.class, (c, p, buildContext) -> INSTANT_START.plusSeconds(buildContext.getSequence()).atZone(ZoneId.systemDefault()).toOffsetDateTime()).registerFromType(ZonedDateTime.class, (c, p, buildContext) -> INSTANT_START.plusSeconds(buildContext.getSequence()).atZone(ZoneId.systemDefault())).registerFromType(Enum.class, (c, p, buildContext) -> {
            Enum[] enums = (Enum[])c.getEnumConstants();
            return enums[(buildContext.getSequence() - 1) % enums.length];
        });
    }

    public <T, B> PropertyBuilder registerFromType(Class<T> propertyType, TriFunction<Class<T>, PropertyWriter<B>, BuildContext<B>, T> builder) {
        this.setters.add(new TypeHandler<TriFunction<Class<T>, PropertyWriter<B>, BuildContext<B>, T>>(propertyType, builder));
        return this;
    }

    public <B> PropertyBuilder registerFromProperty(Predicate<PropertyWriter<B>> predicate, TriFunction<PropertyWriter<B>, Object, BuildContext<B>, Object> builder) {
        this.propertyBuilders.put(predicate, builder);
        return this;
    }

    public PropertyBuilder skipProperty(Predicate<PropertyWriter<?>> predicate) {
        this.skipper.add(predicate);
        return this;
    }

    public <T> T buildDefaultProperty(T object, BuildContext<T> buildContext) {
        buildContext.getBeanClass().getPropertyWriters().values().stream().filter(propertyWriter -> this.skipper.stream().noneMatch(p -> p.test(propertyWriter))).filter(propertyWriter -> buildContext.notSpecified(propertyWriter.getName())).forEach(propertyWriter -> this.buildDefaultProperty(object, (PropertyWriter)propertyWriter, buildContext));
        return object;
    }

    private void buildDefaultProperty(Object object, PropertyWriter propertyWriter, BuildContext<?> buildContext) {
        Stream.concat(this.buildValueFromMethodBuilder(propertyWriter, object, buildContext), this.buildValueFromPropertyBuilder(propertyWriter, buildContext)).findFirst().ifPresent(value -> propertyWriter.setValue(object, value));
    }

    private Stream<Object> buildValueFromMethodBuilder(PropertyWriter propertyWriter, Object object, BuildContext<?> buildContext) {
        return this.propertyBuilders.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(propertyWriter)).map(e -> ((TriFunction)e.getValue()).apply(propertyWriter, object, buildContext));
    }

    private Stream<Object> buildValueFromPropertyBuilder(PropertyWriter propertyWriter, BuildContext<?> buildContext) {
        return Stream.concat(this.setters.stream().filter(s -> s.isPreciseType(propertyWriter.getPropertyType())), this.setters.stream().filter(s -> s.isBaseType(propertyWriter.getPropertyType()))).map(t -> ((TriFunction)t.getHandler()).apply(propertyWriter.getPropertyType(), propertyWriter, buildContext));
    }
}

