/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.AbstractFactory;
import com.github.leeonky.javabuilder.BeanContext;
import com.github.leeonky.javabuilder.BeanSpecs;
import com.github.leeonky.javabuilder.Combination;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;

class BeanSpecsFactory<T>
extends AbstractFactory<T> {
    private final BeanSpecs<T> beanSpecs;

    <B extends BeanSpecs<T>> BeanSpecsFactory(B beanSpecs) {
        super(beanSpecs.getType());
        this.beanSpecs = beanSpecs;
        Stream.of(beanSpecs.getClass().getMethods()).filter(method -> method.getAnnotation(Combination.class) != null).forEach(method -> this.combinable(this.getCombinationName((Method)method), beanContext -> {
            try {
                method.invoke((Object)beanSpecs, beanContext);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }));
    }

    private String getCombinationName(Method method) {
        Combination annotation = method.getAnnotation(Combination.class);
        return annotation.value().isEmpty() ? method.getName() : annotation.value();
    }

    @Override
    public T newInstance(BeanContext<T> beanContext) {
        return beanContext.getFactorySet().type(this.getBeanClass().getType()).build(beanContext.getBuildingContext());
    }

    @Override
    public void collectSpecs(BeanContext<T> beanContext, String ... combinations) {
        this.beanSpecs.specs(beanContext);
        super.collectSpecs(beanContext, combinations);
    }
}

