/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanContext;
import com.github.leeonky.javabuilder.DependencySpec;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import com.github.leeonky.javabuilder.PropertyChain;
import com.github.leeonky.javabuilder.SupplierSpec;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

class BuildingContext {
    private final FactorySet factorySet;
    private Map<PropertyChain, SupplierSpec> propertiesSpecs = new LinkedHashMap<PropertyChain, SupplierSpec>();
    private Map<PropertyChain, SupplierSpec> supplierSpecs = new LinkedHashMap<PropertyChain, SupplierSpec>();
    private Map<PropertyChain, DependencySpec> dependencySpecs = new LinkedHashMap<PropertyChain, DependencySpec>();

    BuildingContext(FactorySet factorySet) {
        this.factorySet = factorySet;
    }

    <T> BeanContext<T> createBeanContext(Factory<T> factory, Map<String, Object> params, Map<String, Object> properties, Consumer<BeanContext<T>> spec, String[] combinations) {
        return new BeanContext<T>(this.factorySet, factory, null, null, this.factorySet.getSequence(factory.getBeanClass().getType()), params, properties, this, spec, combinations);
    }

    void appendSupplierSpec(PropertyChain propertyChain, SupplierSpec spec) {
        this.supplierSpecs.remove(propertyChain);
        this.supplierSpecs.put(propertyChain, spec);
    }

    void appendPropertiesSpec(PropertyChain propertyChain, SupplierSpec spec) {
        this.propertiesSpecs.remove(propertyChain);
        this.propertiesSpecs.put(propertyChain, spec);
    }

    void applyAllSpecs(Object object) {
        this.propertiesSpecs.values().forEach(spec -> spec.apply(object));
        this.supplierSpecs.values().forEach(spec -> spec.apply(object));
        LinkedHashSet<PropertyChain> properties = new LinkedHashSet<PropertyChain>(this.dependencySpecs.keySet());
        while (properties.size() > 0) {
            this.assignFromDependency(object, properties, (PropertyChain)properties.iterator().next());
        }
    }

    private void assignFromDependency(Object object, Set<PropertyChain> properties, PropertyChain property) {
        if (properties.contains(property)) {
            DependencySpec dependencySpec = this.dependencySpecs.get(property);
            dependencySpec.getDependencies().forEach(dependencyDependency -> this.assignFromDependency(object, properties, (PropertyChain)dependencyDependency));
            dependencySpec.apply(object);
            properties.remove(property);
        }
    }

    void appendDependencySpec(PropertyChain propertyChain, DependencySpec spec) {
        this.dependencySpecs.remove(propertyChain);
        this.dependencySpecs.put(propertyChain, spec);
    }
}

