/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.PropertyChain;
import com.github.leeonky.javabuilder.SupplierOnce;
import java.util.Objects;
import java.util.function.Supplier;

class PropertySpec {
    private final Class<?> type;
    private final String conditionPropertyChain;
    private final Object conditionValue;
    private final PropertyChain property;
    private Supplier<?> supplier;

    PropertySpec(Class<?> type, PropertyChain property, Supplier<?> supplier, String conditionPropertyChain, Object conditionValue) {
        this.type = type;
        this.property = property;
        this.supplier = new SupplierOnce(supplier);
        this.conditionPropertyChain = conditionPropertyChain.replaceAll("\\(.*\\)", "").replaceAll(".+\\.", "");
        this.conditionValue = conditionValue;
    }

    void apply(Object object) {
        this.property.setTo(object, this.supplier.get());
    }

    void tryMerge(PropertySpec propertySpec) {
        if (this.type.equals(propertySpec.type) && this.conditionPropertyChain.equals(propertySpec.conditionPropertyChain) && Objects.equals(this.conditionValue, propertySpec.conditionValue)) {
            this.supplier = propertySpec.supplier;
        }
    }
}

