/*
 * Decompiled with CFR 0.152.
 */
package org.liufree.xmindparser;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveException;
import org.dom4j.DocumentException;
import org.liufree.xmindparser.XmindLegacy;
import org.liufree.xmindparser.XmindZen;
import org.liufree.xmindparser.ZipUtils;
import org.liufree.xmindparser.pojo.JsonRootBean;

public class XmindParser {
    public static final String xmindZenJson = "content.json";
    public static final String xmindLegacyContent = "content.xml";
    public static final String xmindLegacyComments = "comments.xml";

    public static String parseJson(String xmindFile) throws IOException, ArchiveException, DocumentException {
        String res = ZipUtils.extract(xmindFile);
        String content = null;
        content = XmindParser.isXmindZen(res, xmindFile) ? XmindParser.getXmindZenContent(xmindFile, res) : XmindParser.getXmindLegacyContent(xmindFile, res);
        File dir = new File(res);
        boolean flag = XmindParser.deleteDir(dir);
        if (flag) {
            // empty if block
        }
        JsonRootBean jsonRootBean = (JsonRootBean)JSON.parseObject((String)content, JsonRootBean.class);
        return JSON.toJSONString((Object)jsonRootBean, (boolean)false);
    }

    public static Object parseObject(String xmindFile) throws DocumentException, ArchiveException, IOException {
        String content = XmindParser.parseJson(xmindFile);
        JsonRootBean jsonRootBean = (JsonRootBean)JSON.parseObject((String)content, JsonRootBean.class);
        return jsonRootBean;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = XmindParser.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getXmindZenContent(String xmindFile, String extractFileDir) throws IOException, ArchiveException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(xmindZenJson);
        Map<String, String> map = ZipUtils.getContents(keys, xmindFile, extractFileDir);
        String content = map.get(xmindZenJson);
        content = XmindZen.getContent(content);
        return content;
    }

    public static String getXmindLegacyContent(String xmindFile, String extractFileDir) throws IOException, ArchiveException, DocumentException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(xmindLegacyContent);
        keys.add(xmindLegacyComments);
        Map<String, String> map = ZipUtils.getContents(keys, xmindFile, extractFileDir);
        String contentXml = map.get(xmindLegacyContent);
        String commentsXml = map.get(xmindLegacyComments);
        String xmlContent = XmindLegacy.getContent(contentXml, commentsXml);
        return xmlContent;
    }

    private static boolean isXmindZen(String res, String xmindFile) throws IOException, ArchiveException {
        File parent = new File(res);
        if (parent.isDirectory()) {
            String[] files = parent.list(new ZipUtils.FileFilter());
            for (int i = 0; i < Objects.requireNonNull(files).length; ++i) {
                if (!files[i].equals(xmindZenJson)) continue;
                return true;
            }
        }
        return false;
    }
}

