/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.config;

import com.github.lit.code.config.JdbcConfig;
import com.github.lit.code.context.Table;
import com.github.lit.code.context.Task;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Configuration {
    private static final Map<String, String> DEFAULT_CONVERT_MAP = new ConcurrentHashMap<String, String>();
    private Map<String, String> constantMap = new HashMap<String, String>();
    private Map<String, String> converterMap = new HashMap<String, String>();
    private Map<String, Task> taskMap = new HashMap<String, Task>();
    private JdbcConfig jdbcConfig;
    private Table table;

    public void addConstant(String key, String value) {
        this.constantMap.put(key, value);
    }

    public String getConstant(String key) {
        return this.constantMap.get(key);
    }

    public String getConstant(String key, String defaultValue) {
        String value = this.constantMap.get(key);
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getBooleanConstant(String key) {
        String value = this.constantMap.get(key);
        if (value == null || value.length() == 0) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBooleanConstant(String key, Boolean defaultValue) {
        String value = this.constantMap.get(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public void addTask(Task task) {
        if (task == null) {
            return;
        }
        this.taskMap.put(task.getName(), task);
    }

    public Task getTask(String key) {
        return this.taskMap.get(key);
    }

    public void addConverter(String key, String value) {
        this.converterMap.put(key, value);
    }

    public String getConverter(String key) {
        String value = this.converterMap.get(key);
        if (value == null || value.isEmpty()) {
            value = DEFAULT_CONVERT_MAP.get(key);
        }
        return value;
    }

    public Map<String, String> getConstantMap() {
        return this.constantMap;
    }

    public Map<String, String> getConverterMap() {
        return this.converterMap;
    }

    public Map<String, Task> getTaskMap() {
        return this.taskMap;
    }

    public JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public Table getTable() {
        return this.table;
    }

    public void setConstantMap(Map<String, String> constantMap) {
        this.constantMap = constantMap;
    }

    public void setConverterMap(Map<String, String> converterMap) {
        this.converterMap = converterMap;
    }

    public void setTaskMap(Map<String, Task> taskMap) {
        this.taskMap = taskMap;
    }

    public void setJdbcConfig(JdbcConfig jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String toString() {
        return "Configuration(constantMap=" + this.getConstantMap() + ", converterMap=" + this.getConverterMap() + ", taskMap=" + this.getTaskMap() + ", jdbcConfig=" + this.getJdbcConfig() + ", table=" + this.getTable() + ")";
    }

    static {
        DEFAULT_CONVERT_MAP.put(JDBCType.REAL.getName(), Float.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.DECIMAL.getName(), BigDecimal.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.NUMERIC.getName(), BigDecimal.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.CHAR.getName(), String.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.LONGVARCHAR.getName(), String.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.CLOB.getName(), String.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.BINARY.getName(), Byte.class.getName() + "[]");
        DEFAULT_CONVERT_MAP.put(JDBCType.VARBINARY.getName(), Byte.class.getName() + "[]");
        DEFAULT_CONVERT_MAP.put(JDBCType.LONGVARBINARY.getName(), Byte.class.getName() + "[]");
        DEFAULT_CONVERT_MAP.put(JDBCType.BLOB.getName(), Byte.class.getName() + "[]");
        DEFAULT_CONVERT_MAP.put(JDBCType.DATE.getName(), Date.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.TIME.getName(), Date.class.getName());
        DEFAULT_CONVERT_MAP.put(JDBCType.TIMESTAMP.getName(), Date.class.getName());
        DEFAULT_CONVERT_MAP.put("TINYTEXT", String.class.getName());
        DEFAULT_CONVERT_MAP.put("TEXT", String.class.getName());
        DEFAULT_CONVERT_MAP.put("LONGTEXT", String.class.getName());
    }
}

