/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ClassUtils {
    public static Object getFieldValue(Field field, Object obj) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5bf9\u8c61\u7684\u5c5e\u6027\u503c\u5931\u8d25\uff1a" + field.getName(), e);
        }
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u8bbe\u7f6e\u5bf9\u8c61\u7684\u5c5e\u6027\u503c\u5931\u8d25\uff1a" + field.getName(), e);
        }
    }

    public static Object invokeMethod(Method method, Object obj, Object ... value) {
        ClassUtils.methodAccessible(method);
        try {
            return method.invoke(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Method \u8c03\u7528\u5931\u8d25 " + (method == null ? "null" : method.getName()), e);
        }
    }

    public static void methodAccessible(Method method) {
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + (clazz == null ? "null" : clazz.getName()), e);
        }
    }

    public static Object newInstance(String clazz) {
        try {
            Class<?> loadClass = ClassUtils.getDefaultClassLoader().loadClass(clazz);
            return loadClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6839\u636eclass\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:" + clazz, e);
        }
    }

    public static Class<?> loadClass(String clazz) {
        try {
            return ClassUtils.getDefaultClassLoader().loadClass(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6839\u636eclass\u540d\u79f0\u52a0\u8f7dclass\u5931\u8d25:" + clazz, e);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }
        return classLoader;
    }
}

