/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.util;

public class NameUtils {
    public static String getCamelName(String name) {
        return NameUtils.getCamelName(name, "_");
    }

    public static String getCamelName(String name, String delimiter) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        char delimiterChar = delimiter.charAt(0);
        StringBuilder sb = new StringBuilder();
        name = name.toLowerCase();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == delimiterChar) {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getFirstUpperName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String getFirstLowerName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String getUnderLineName(String name) {
        return NameUtils.getLowerDelimiterName(name, "_");
    }

    public static String getLowerDelimiterName(String name, String delimiter) {
        return NameUtils.getUpperDelimiterName(name, delimiter).toLowerCase();
    }

    public static String getUpperDelimiterName(String name, String delimiter) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append(delimiter);
            }
            sb.append(c);
        }
        return sb.toString().toUpperCase();
    }
}

