/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code;

import com.github.lit.code.config.Configuration;
import com.github.lit.code.config.ConfigurationBuilder;
import com.github.lit.code.context.GenerationException;
import com.github.lit.code.datebase.DataBaseProvider;
import com.github.lit.code.datebase.DateBaseProviderFactory;
import com.github.lit.code.executor.GenerationExecutor;
import com.github.lit.code.parser.ConfigParser;
import java.util.logging.Logger;

public class CodeGeneration {
    private static final Logger LOGGER = Logger.getLogger(CodeGeneration.class.getName());

    public static void run() {
        CodeGeneration.run("code.json");
    }

    public static void run(String configFile) {
        if (configFile == null || configFile.length() == 0) {
            throw new GenerationException("\u914d\u7f6e\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Configuration configuration = ConfigurationBuilder.build(configFile);
        GenerationExecutor.execute(configuration);
    }

    public static void registerParser(ConfigParser configParser) {
        ConfigurationBuilder.registerParser(configParser);
    }

    public static void registerProvider(DataBaseProvider dataBaseProvider) {
        DateBaseProviderFactory.registerProvider(dataBaseProvider);
    }
}

