/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.config;

import com.github.lit.code.config.Configuration;
import com.github.lit.code.context.GenerationException;
import com.github.lit.code.parser.ConfigParser;
import com.github.lit.code.parser.ConverterParser;
import com.github.lit.code.parser.JdbcParser;
import com.github.lit.code.parser.TableParser;
import com.github.lit.code.parser.TasksParser;
import com.github.lit.util.ClassUtils;
import com.github.lit.util.TokenUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigurationBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationBuilder.class.getName());
    private static final List<ConfigParser> CONFIG_PARSERS = new ArrayList<ConfigParser>();

    public static Configuration build(String configFile) {
        InputStream inputStream;
        if (configFile.startsWith("/")) {
            configFile = configFile.substring(1);
        }
        if ((inputStream = ClassUtils.getDefaultClassLoader().getResourceAsStream(configFile)) == null) {
            throw new GenerationException(String.format("\u672a\u80fd\u627e\u5230\u914d\u7f6e\u6587\u4ef6 %s, \u8bf7\u786e\u8ba4\u8be5\u6587\u4ef6\u653e\u5728 classpath \u8def\u5f84\u4e0b", configFile));
        }
        Configuration configuration = new Configuration();
        JsonElement rootElement = new JsonParser().parse((Reader)new InputStreamReader(inputStream));
        if (rootElement.isJsonArray()) {
            throw new GenerationException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u662f\u6570\u7ec4");
        }
        JsonObject constant = rootElement.getAsJsonObject().getAsJsonObject().getAsJsonObject("constant");
        for (Map.Entry entry : constant.entrySet()) {
            configuration.addConstant((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        String rootConfigJson = TokenUtils.parseToken(configuration.getConstantMap(), (String)rootElement.toString());
        JsonObject rootObject = new JsonParser().parse(rootConfigJson).getAsJsonObject();
        LOGGER.info("\u5f00\u59cb\u89e3\u6790\u914d\u7f6e\u6587\u4ef6: " + configFile);
        for (ConfigParser configParser : CONFIG_PARSERS) {
            JsonElement jsonElement = rootObject.get(configParser.getConfigKey());
            if (jsonElement == null) continue;
            configParser.parser(configuration, jsonElement);
        }
        LOGGER.info("\u5b8c\u6210\u914d\u7f6e\u6587\u4ef6: " + configFile + " \u7684\u89e3\u6790!");
        return configuration;
    }

    public static void registerParser(ConfigParser configParser) {
        CONFIG_PARSERS.add(configParser);
    }

    static {
        CONFIG_PARSERS.add(new JdbcParser());
        CONFIG_PARSERS.add(new ConverterParser());
        CONFIG_PARSERS.add(new TableParser());
        CONFIG_PARSERS.add(new TasksParser());
    }
}

