/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.context;

import com.github.lit.util.NameUtils;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

public class Task
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Task.class.getName());
    private static final long serialVersionUID = 5454351511354251547L;
    private String name;
    private String tableName;
    private String generateClass;
    private String template;
    private String prefixRemove = "";
    private String suffixRemove = "";
    private String delimiter = "_";
    private String prefixAdd = "";
    private String suffixAdd = "";
    private String fileType = ".java";
    private Boolean upperCase = false;
    private Boolean lowerCase = false;
    private Boolean camel = false;
    private String fileSeparator = "";
    private String module = "";
    private String srcDir = "src/main/java";
    private String _package = "";
    private List<String> plugins;

    public String getShortClassName() {
        String resultName = NameUtils.getFirstUpperName((String)NameUtils.getCamelName((String)this.tableName, (String)this.delimiter));
        return this.prefixAdd + resultName + this.suffixAdd;
    }

    public String getLongClassName() {
        return this._package + "." + this.getShortClassName();
    }

    public String getFirstLowerClassName() {
        if (this.prefixAdd == null || this.prefixAdd.isEmpty()) {
            return NameUtils.getCamelName((String)this.tableName) + this.suffixAdd;
        }
        return NameUtils.getFirstLowerName((String)this.getShortClassName());
    }

    public String getUnderLineSplitName() {
        return NameUtils.getLowerDelimiterName((String)this.getShortClassName(), (String)"_");
    }

    public String getMiddleLineSplitName() {
        return NameUtils.getLowerDelimiterName((String)this.getShortClassName(), (String)"-");
    }

    public String getPathSplitName() {
        return NameUtils.getLowerDelimiterName((String)this.getShortClassName(), (String)"/");
    }

    public String getUpperName() {
        return this.getShortClassName().toUpperCase();
    }

    public String getLowerName() {
        return this.getShortClassName().toLowerCase();
    }

    public String processTableName(String tableName) {
        if (this.prefixRemove != null && !this.prefixRemove.isEmpty()) {
            if (tableName.startsWith(this.prefixRemove)) {
                tableName = tableName.substring(this.prefixRemove.length());
            } else {
                LOGGER.warning(String.format("table %s \u8bbe\u7f6e\u79fb\u9664\u7684\u524d\u7f00 %s \u65e0\u6548!", tableName, this.prefixRemove));
            }
        }
        if (this.suffixRemove != null && !this.suffixRemove.isEmpty() && tableName.endsWith(this.suffixRemove)) {
            tableName = tableName.substring(0, tableName.length() - this.suffixRemove.length());
        }
        if (tableName.startsWith(this.delimiter)) {
            tableName = tableName.substring(this.delimiter.length());
        }
        if (tableName.endsWith(this.delimiter)) {
            tableName = tableName.substring(0, tableName.length() - this.delimiter.length());
        }
        return tableName;
    }

    public String getFileName() {
        String resultName = null;
        if (this.camel.booleanValue()) {
            resultName = this.getShortClassName();
        } else if (this.upperCase.booleanValue()) {
            resultName = this.prefixAdd + this.tableName.replace(this.delimiter, this.fileSeparator).toUpperCase() + this.suffixAdd;
        } else if (this.lowerCase.booleanValue()) {
            resultName = this.prefixAdd + this.tableName.replace(this.delimiter, this.fileSeparator).toLowerCase() + this.suffixAdd;
        }
        if (resultName == null) {
            resultName = this.getShortClassName();
        }
        String longName = (this.get_package() + "." + resultName).replace(".", File.separator);
        if (!this.srcDir.startsWith(File.separator)) {
            this.srcDir = File.separator + this.srcDir;
        }
        if (!this.srcDir.endsWith(File.separator)) {
            this.srcDir = this.srcDir + File.separator;
        }
        if (!this.fileType.startsWith(".")) {
            this.fileType = "." + this.fileType;
        }
        return this.srcDir + longName + this.fileType;
    }

    public String getPackageName() {
        return this._package;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getGenerateClass() {
        return this.generateClass;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getPrefixRemove() {
        return this.prefixRemove;
    }

    public String getSuffixRemove() {
        return this.suffixRemove;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getPrefixAdd() {
        return this.prefixAdd;
    }

    public String getSuffixAdd() {
        return this.suffixAdd;
    }

    public String getFileType() {
        return this.fileType;
    }

    public Boolean getUpperCase() {
        return this.upperCase;
    }

    public Boolean getLowerCase() {
        return this.lowerCase;
    }

    public Boolean getCamel() {
        return this.camel;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getModule() {
        return this.module;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public String get_package() {
        return this._package;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setGenerateClass(String generateClass) {
        this.generateClass = generateClass;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setPrefixRemove(String prefixRemove) {
        this.prefixRemove = prefixRemove;
    }

    public void setSuffixRemove(String suffixRemove) {
        this.suffixRemove = suffixRemove;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setPrefixAdd(String prefixAdd) {
        this.prefixAdd = prefixAdd;
    }

    public void setSuffixAdd(String suffixAdd) {
        this.suffixAdd = suffixAdd;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setUpperCase(Boolean upperCase) {
        this.upperCase = upperCase;
    }

    public void setLowerCase(Boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setCamel(Boolean camel) {
        this.camel = camel;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public void set_package(String _package) {
        this._package = _package;
    }

    public void setPlugins(List<String> plugins) {
        this.plugins = plugins;
    }

    public String toString() {
        return "Task(name=" + this.getName() + ", tableName=" + this.getTableName() + ", generateClass=" + this.getGenerateClass() + ", template=" + this.getTemplate() + ", prefixRemove=" + this.getPrefixRemove() + ", suffixRemove=" + this.getSuffixRemove() + ", delimiter=" + this.getDelimiter() + ", prefixAdd=" + this.getPrefixAdd() + ", suffixAdd=" + this.getSuffixAdd() + ", fileType=" + this.getFileType() + ", upperCase=" + this.getUpperCase() + ", lowerCase=" + this.getLowerCase() + ", camel=" + this.getCamel() + ", fileSeparator=" + this.getFileSeparator() + ", module=" + this.getModule() + ", srcDir=" + this.getSrcDir() + ", _package=" + this.get_package() + ", plugins=" + this.getPlugins() + ")";
    }
}

