/*
 * Decompiled with CFR 0.152.
 */
package miniml;

import java.util.ArrayList;
import java.util.List;
import miniml.Document;

public class Node {
    private Document parentDoc;
    private String name;
    private Node parent;
    private final List<Node> children;
    final List<String> values;

    Node(String name, Node parent, Document parentDocument, boolean update) {
        this.name = name;
        this.parent = parent;
        this.parentDoc = parentDocument;
        this.children = new ArrayList<Node>();
        this.values = new ArrayList<String>();
        if (this.parent != null) {
            this.parent.children.add(this);
            if (update) {
                this.parentDoc.update();
            }
        }
    }

    public void addValue(String newValue) {
        this.values.add(newValue);
        this.parentDoc.update();
    }

    public void removeValue(String value) {
        if (!this.values.remove(value)) {
            throw new IllegalArgumentException("The value \"" + value + "\" was not found.");
        }
        this.parentDoc.update();
    }

    public void removeChild(Node child) {
        if (!this.children.remove(child)) {
            throw new IllegalArgumentException("The node with name \"" + child.name + "\" was not found.");
        }
        this.parentDoc.update();
    }

    public void removeChildrenByName(String name) {
        this.children.removeIf(child -> child.name.contentEquals(name));
        this.parentDoc.update();
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildren() {
        return new ArrayList<Node>(this.children);
    }

    public List<Node> getChildrenByName(String name) {
        ArrayList<Node> sameName = new ArrayList<Node>();
        this.children.forEach(child -> {
            if (child.name.contentEquals(name)) {
                sameName.add((Node)child);
            }
        });
        return sameName;
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    String asString(int indent) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder res = new StringBuilder();
        res.append("\t".repeat(indent)).append(this.name).append(lineSep);
        this.values.forEach(value -> res.append("\t".repeat(indent + 1)).append("=").append((String)value).append(lineSep));
        this.children.forEach(child -> res.append(child.asString(indent + 1)));
        res.append("\t".repeat(indent)).append("__end__").append(lineSep);
        return res.toString();
    }
}

