/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public class Collectors {

    public static class Distinct {
        public static <T> Collector<T, ?, List<T>> distinctLastPut() {
            return Distinct.distinctByKey(Function.identity(), Order.LAST_PUT, Distinct.last());
        }

        public static <T> Collector<T, ?, List<T>> distinctLastPutByKey(Function<? super T, ?> keyExtractor) {
            return Distinct.distinctByKey(keyExtractor, Order.LAST_PUT, Distinct.last());
        }

        public static <T> Collector<T, ?, List<T>> distinctFirstPut() {
            return Distinct.distinctByKey(Function.identity(), Order.FIRST_PUT, Distinct.first());
        }

        public static <T> Collector<T, ?, List<T>> distinctFirstPutByKey(Function<? super T, ?> keyExtractor) {
            return Distinct.distinctByKey(keyExtractor, Order.FIRST_PUT, Distinct.first());
        }

        private static <T> Collector<T, ?, List<T>> distinctByKey(Function<? super T, ?> keyExtractor, Order order, Function<List<T>, T> finisher) {
            return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.groupingBy(keyExtractor, () -> Distinct.buildMap(order), java.util.stream.Collectors.toList()), res -> res.values().stream().map(finisher).collect(java.util.stream.Collectors.toList()));
        }

        private static <K, V> Map<K, V> buildMap(Order order) {
            switch (order) {
                case FIRST_PUT: {
                    return new LinkedHashMap();
                }
                case LAST_PUT: {
                    return new LinkedHashMap(16, 0.75f, true);
                }
            }
            throw new IllegalStateException("not support order = " + (Object)((Object)order));
        }

        private static <T> Function<List<T>, T> last() {
            return li -> li.get(li.size() - 1);
        }

        private static <T> Function<List<T>, T> first() {
            return li -> li.get(0);
        }

        private static enum Order {
            FIRST_PUT,
            LAST_PUT;

        }
    }

    public static class Reversed {
        public static <T> Collector<T, ?, List<T>> reversed() {
            return Reversed.reversed(Function.identity());
        }

        public static <T, R> Collector<T, ?, R> reversed(Function<List<T>, R> finisher) {
            return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toList(), list -> {
                Collections.reverse(list);
                return finisher.apply((List)list);
            });
        }
    }
}

