/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class Types {
    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static <T> Class<T> getClass(T t) {
        return t.getClass();
    }

    public static <T> Class<T> getGeneric(Object object, Class<?> clazz) {
        if (LambdaGeneric.isLambda(object)) {
            return (Class)Types.cast(LambdaGeneric.getGeneric(object));
        }
        return (Class)Types.cast(ObjectGeneric.getGeneric(object, clazz));
    }

    private static class LambdaGeneric {
        private LambdaGeneric() {
        }

        public static boolean isLambda(Object object) {
            String functionClassName = object.getClass().getName();
            int lambdaMarkerIndex = functionClassName.indexOf("$$Lambda$");
            return lambdaMarkerIndex != -1;
        }

        public static Class<?> getGeneric(Object lambda) {
            if (!LambdaGeneric.isLambda(lambda)) {
                throw new IllegalArgumentException("object = " + lambda + " not lambda");
            }
            return (Class)LambdaGeneric.method(lambda).getParameters()[0].getParameterizedType();
        }

        private static Method method(Object lambda) {
            SerializedLambda serialized = LambdaGeneric.serialized(lambda);
            Class<?> containingClass = LambdaGeneric.getContainingClass(serialized);
            return Arrays.stream(containingClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), serialized.getImplMethodName())).findFirst().orElseThrow(() -> new IllegalStateException("clazz not implement Serializable"));
        }

        private static SerializedLambda serialized(Object lambda) {
            Method writeMethod = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeMethod.setAccessible(true);
            return (SerializedLambda)writeMethod.invoke(lambda, new Object[0]);
        }

        private static Class<?> getContainingClass(SerializedLambda lambda) {
            String className = lambda.getImplClass().replaceAll("/", ".");
            return Class.forName(className);
        }
    }

    private static class ObjectGeneric {
        private ObjectGeneric() {
        }

        public static Class<?> getGeneric(Object object, Class<?> clazz) {
            Type[] types;
            for (Type type : types = object.getClass().getGenericInterfaces()) {
                if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != clazz) continue;
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            throw new IllegalStateException("object not a instance of " + clazz.getTypeName());
        }
    }
}

