/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import com.github.lokic.javaplus.functional.function.Function2;
import com.github.lokic.javaplus.functional.function.Function3;
import com.github.lokic.javaplus.tuple.Tuple;
import java.util.ArrayList;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Memoized {
    public static <T, R> Function<T, R> of(Function<T, R> function) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return t -> cache.computeIfAbsent(t, function);
    }

    public static <T1, T2, R> Function2<T1, T2, R> of(Function2<T1, T2, R> function2) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return (t1, t2) -> cache.computeIfAbsent(Tuple.of(t1, t2), t -> function2.apply(t.getT1(), t.getT2()));
    }

    public static <T1, T2, T3, R> Function3<T1, T2, T3, R> of(Function3<T1, T2, T3, R> function3) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return (t1, t2, t3) -> cache.computeIfAbsent(Tuple.of(t1, t2, t3), t -> function3.apply(t.getT1(), t.getT2(), t.getT3()));
    }

    public static <T> Supplier<Stream<T>> of(Supplier<Stream<T>> streamSupplier) {
        final Spliterator spliterator = streamSupplier.get().spliterator();
        final ArrayList cache = new ArrayList();
        return () -> {
            Spliterators.AbstractSpliterator split = new Spliterators.AbstractSpliterator<T>(spliterator.estimateSize(), spliterator.characteristics()){
                private int index;
                private boolean hasNext;
                {
                    super(x0, x1);
                    this.index = 0;
                    this.hasNext = true;
                }

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    int currentIndex;
                    if ((currentIndex = this.index++) < cache.size()) {
                        action.accept(cache.get(currentIndex));
                        return true;
                    }
                    if (this.hasNext) {
                        this.hasNext = spliterator.tryAdvance(item -> {
                            cache.add(item);
                            action.accept(item);
                        });
                    }
                    return this.hasNext;
                }
            };
            return StreamSupport.stream(split, false);
        };
    }
}

