/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;

final class AnnotationValues {
    private AnnotationValues() {
    }

    static boolean asBoolean(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor9<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(Object o, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public Boolean visitBoolean(boolean b, Void p) {
                return b;
            }
        }, null);
    }

    static TypeElement asType(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor9<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Object o, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public TypeElement visitType(TypeMirror t, Void p) {
                return t.accept(new SimpleTypeVisitor9<TypeElement, Void>(){

                    @Override
                    protected TypeElement defaultAction(TypeMirror e, Void p) {
                        throw new AssertionError();
                    }

                    @Override
                    public TypeElement visitDeclared(DeclaredType t, Void p) {
                        return (TypeElement)Iterables.getOnlyElement(ElementFilter.typesIn((Iterable<? extends Element>)ImmutableList.of((Object)t.asElement())));
                    }
                }, null);
            }
        }, null);
    }

    static <E extends Enum<E>> E asEnum(AnnotationValue value, final Class<E> enumType) {
        return (E)((Enum)value.accept(new SimpleAnnotationValueVisitor9<E, Void>(){

            @Override
            protected E defaultAction(Object o, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public E visitEnumConstant(VariableElement vare, Void p) {
                return Enum.valueOf(enumType, vare.getSimpleName().toString());
            }
        }, null));
    }

    static ImmutableList<? extends AnnotationValue> asList(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor9<ImmutableList<? extends AnnotationValue>, Void>(){

            @Override
            protected ImmutableList<? extends AnnotationValue> defaultAction(Object o, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public ImmutableList<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> vals, Void p) {
                return ImmutableList.copyOf(vals);
            }
        }, null);
    }
}

