/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.github.longdt.vertxorm.annotation.Repository;
import com.github.longdt.vertxorm.codegen.EntityDeclaration;
import com.github.longdt.vertxorm.codegen.RepositoryDeclaration;
import com.github.longdt.vertxorm.codegen.RepositoryDescriptor;
import com.github.longdt.vertxorm.codegen.RepositoryWriter;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class CodeGenProcessor
extends AbstractProcessor {
    private RepositoryDeclaration.Factory repositoryDF;
    private EntityDeclaration.Factory entityDF;
    private Messager messager;
    private Elements elements;
    private Types types;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
        this.messager = env.getMessager();
        this.repositoryDF = new RepositoryDeclaration.Factory(this.elements, this.messager);
        this.entityDF = new EntityDeclaration.Factory(this.elements, this.types, this.messager);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(roundEnv);
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process @Repository annotations:\n" + Throwables.getStackTraceAsString((Throwable)e));
        }
        return false;
    }

    private void doProcess(RoundEnvironment roundEnv) throws IOException {
        for (Element element : roundEnv.getElementsAnnotatedWith(Repository.class)) {
            Optional<RepositoryDeclaration> declaration = this.repositoryDF.createIfValid(element);
            if (declaration.isPresent()) {
                RepositoryDeclaration repositoryDeclaration = declaration.get();
                Optional<EntityDeclaration> entityDeclarationOpt = this.entityDF.createIfValid(repositoryDeclaration);
                if (entityDeclarationOpt.isEmpty()) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process repository: " + repositoryDeclaration.className());
                    continue;
                }
                RepositoryDescriptor descriptor = RepositoryDescriptor.create(repositoryDeclaration, entityDeclarationOpt.get());
                new RepositoryWriter(this.processingEnv).writeRepository(descriptor);
            }
            System.out.println(declaration);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Repository.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

