/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.github.longdt.vertxorm.codegen.AnnotationHelper;
import com.github.longdt.vertxorm.codegen.AutoValue_EntityDeclaration;
import com.github.longdt.vertxorm.codegen.AutoValue_FieldDeclaration;
import com.github.longdt.vertxorm.codegen.FieldDeclaration;
import com.github.longdt.vertxorm.codegen.RepositoryDeclaration;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.tools.Diagnostic;

@AutoValue
abstract class EntityDeclaration {
    EntityDeclaration() {
    }

    abstract TypeElement targetType();

    abstract String tableName();

    abstract FieldDeclaration pkField();

    abstract boolean autoGenPK();

    abstract Map<String, FieldDeclaration> fieldsMap();

    public static class Factory {
        private final Elements elements;
        private final Types types;
        private final Messager messager;

        public Factory(Elements elements, Types types, Messager messager) {
            this.elements = elements;
            this.types = types;
            this.messager = messager;
        }

        Optional<EntityDeclaration> createIfValid(RepositoryDeclaration repositoryDeclaration) {
            TypeElement repoElement = (TypeElement)repositoryDeclaration.target();
            DeclaredType declaredType = (DeclaredType)repoElement.getInterfaces().get(0);
            Element entityElement = ((DeclaredType)declaredType.getTypeArguments().get(1)).asElement();
            TypeMirror idType = declaredType.getTypeArguments().get(0);
            Entity entity = entityElement.getAnnotation(Entity.class);
            String tableName = entity.name();
            boolean hasNoParameterConstructor = ElementFilter.constructorsIn(entityElement.getEnclosedElements()).stream().anyMatch(constructor -> constructor.getParameters().isEmpty());
            if (!hasNoParameterConstructor) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a valid no param constructor for entity. Entity must have a no-arg constructor.", entityElement.getSimpleName()), entityElement, null, null);
                return Optional.empty();
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.elements.getAllMembers((TypeElement)entityElement));
            Optional<VariableElement> idOpt = this.findIdField(entityElement);
            if (idOpt.isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s has no valid id. Entity must have a id field.", entityElement.getSimpleName()), entityElement, null, null);
                return Optional.empty();
            }
            FieldDeclaration pk = this.createPkField(idOpt.get(), methods);
            boolean autoGenPk = idOpt.get().getAnnotation(GeneratedValue.class) != null;
            TreeMap fields = this.createFields((TypeElement)entityElement, methods).stream().filter(field -> !field.fieldName().equals(pk.fieldName())).collect(TreeMap::new, (m, e) -> m.put(e.fieldName(), e), Map::putAll);
            return Optional.of(new AutoValue_EntityDeclaration((TypeElement)entityElement, tableName, pk, autoGenPk, fields));
        }

        Optional<VariableElement> findIdField(Element entityElement) {
            return ElementFilter.fieldsIn(entityElement.getEnclosedElements()).stream().filter(f -> f.getAnnotation(Id.class) != null).findAny();
        }

        FieldDeclaration createPkField(VariableElement pkField, List<ExecutableElement> methods) {
            String pkName = pkField.getSimpleName().toString();
            Optional<ExecutableElement> getter = methods.stream().filter(m -> this.isPropertyMethod((ExecutableElement)m, "get", pkName)).findAny();
            if (getter.isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s has no valid getter. id must have getter method.", pkName));
            }
            Optional<ExecutableElement> setter = methods.stream().filter(m -> this.isPropertyMethod((ExecutableElement)m, "set", pkName)).findAny();
            Optional<TypeMirror> converter = Optional.empty();
            Convert convert = pkField.getAnnotation(Convert.class);
            if (convert != null) {
                converter = Optional.ofNullable(AnnotationHelper.getTypeMirror(this.elements, () -> ((Convert)convert).converter()));
            }
            return new AutoValue_FieldDeclaration(pkName, getter.get().getReturnType(), Optional.empty(), converter);
        }

        List<FieldDeclaration> createFields(TypeElement entityElement, List<ExecutableElement> methods) {
            Map fieldMap = AnnotationHelper.getAllFields(this.types, entityElement).stream().collect(Collectors.toMap(e -> e.getSimpleName().toString(), Function.identity()));
            HashMap<String, ExecutableElement> getterMap = new HashMap<String, ExecutableElement>(methods.size());
            HashMap<String, ExecutableElement> setterMap = new HashMap<String, ExecutableElement>(methods.size());
            for (ExecutableElement method : methods) {
                String fieldName;
                String methodName = method.getSimpleName().toString();
                if (methodName.startsWith("get")) {
                    fieldName = this.getFieldName(methodName);
                    getterMap.put(fieldName, method);
                    continue;
                }
                if (!methodName.startsWith("set")) continue;
                fieldName = this.getFieldName(methodName);
                setterMap.put(fieldName, method);
            }
            return getterMap.entrySet().stream().filter(entry -> setterMap.containsKey(entry.getKey())).map(entry -> {
                Convert convert;
                VariableElement field = (VariableElement)fieldMap.get(entry.getKey());
                Optional<TypeMirror> converter = Optional.empty();
                if (field != null && (convert = field.getAnnotation(Convert.class)) != null) {
                    converter = Optional.ofNullable(AnnotationHelper.getTypeMirror(this.elements, () -> ((Convert)convert).converter()));
                }
                return new AutoValue_FieldDeclaration((String)entry.getKey(), ((ExecutableElement)entry.getValue()).getReturnType(), Optional.empty(), converter);
            }).collect(Collectors.toList());
        }

        private boolean isPropertyMethod(ExecutableElement method, String prefix, String fieldName) {
            String methodName = method.getSimpleName().toString();
            return methodName.length() == prefix.length() + fieldName.length() && methodName.startsWith(prefix) && methodName.charAt(prefix.length()) == Character.toUpperCase(fieldName.charAt(0)) && methodName.regionMatches(prefix.length() + 1, fieldName, 1, fieldName.length() - 1);
        }

        private String getFieldName(String propertyMethodName) {
            return Character.toLowerCase(propertyMethodName.charAt(3)) + propertyMethodName.substring(4);
        }
    }
}

