/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleElementVisitor6;

final class Mirrors {
    private Mirrors() {
    }

    static Name getQualifiedName(DeclaredType type) {
        return type.asElement().accept(new SimpleElementVisitor6<Name, Void>(){

            @Override
            protected Name defaultAction(Element e, Void p) {
                throw new AssertionError((Object)"DeclaredTypes should be TypeElements");
            }

            @Override
            public Name visitType(TypeElement e, Void p) {
                return e.getQualifiedName();
            }
        }, null);
    }

    static ImmutableMap<String, AnnotationValue> simplifyAnnotationValueMap(Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationValueMap.entrySet()) {
            builder.put((Object)entry.getKey().getSimpleName().toString(), (Object)entry.getValue());
        }
        return builder.build();
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationType) {
        String annotationName = annotationType.getName();
        return element.getAnnotationMirrors().stream().filter(a -> Mirrors.getQualifiedName(a.getAnnotationType()).contentEquals(annotationName)).map(x -> x).findFirst();
    }

    static <T> Optional<Equivalence.Wrapper<T>> wrapOptionalInEquivalence(Equivalence<T> equivalence, Optional<T> optional) {
        return optional.map(arg_0 -> equivalence.wrap(arg_0));
    }

    static <T> Optional<T> unwrapOptionalEquivalence(Optional<Equivalence.Wrapper<T>> wrappedOptional) {
        return wrappedOptional.map(Equivalence.Wrapper::get);
    }
}

