/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.codegen;

import com.github.longdt.vertxorm.annotation.Driver;
import com.github.longdt.vertxorm.annotation.NamingStrategy;
import com.github.longdt.vertxorm.codegen.CodeGenProcessor;
import com.github.longdt.vertxorm.codegen.EntityDeclaration;
import com.github.longdt.vertxorm.codegen.FieldDeclaration;
import com.github.longdt.vertxorm.codegen.NamingStrategies;
import com.github.longdt.vertxorm.codegen.RepositoryDescriptor;
import com.github.longdt.vertxorm.repository.CrudRepository;
import com.github.longdt.vertxorm.repository.RowMapper;
import com.github.longdt.vertxorm.repository.base.RowMapperImpl;
import com.github.longdt.vertxorm.repository.postgresql.AbstractCrudRepository;
import com.google.auto.common.GeneratedAnnotationSpecs;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.vertx.sqlclient.Pool;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class RepositoryWriter {
    private final Filer filer;
    private final Elements elements;
    private final SourceVersion sourceVersion;
    private final Types types;

    RepositoryWriter(ProcessingEnvironment processingEnv) {
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.types = processingEnv.getTypeUtils();
    }

    void writeRepository(RepositoryDescriptor descriptor) throws IOException {
        String factoryName = descriptor.name().className();
        TypeSpec.Builder factory = TypeSpec.classBuilder((String)factoryName).addOriginatingElement((Element)descriptor.repositoryDeclaration().targetType());
        GeneratedAnnotationSpecs.generatedAnnotationSpec((Elements)this.elements, (SourceVersion)this.sourceVersion, CodeGenProcessor.class, (String)"Do not edit this file").ifPresent(arg_0 -> ((TypeSpec.Builder)factory).addAnnotation(arg_0));
        factory.addSuperinterface(descriptor.repositoryDeclaration().targetType().asType());
        factory.addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addSuperclass(factory, descriptor);
        this.addConstructor(factory, descriptor);
        JavaFile.builder((String)descriptor.name().packageName(), (TypeSpec)factory.build()).skipJavaLangImports(true).build().writeTo(this.filer);
    }

    private void addConstructor(TypeSpec.Builder factory, RepositoryDescriptor descriptor) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        constructor.addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructor.addParameter(TypeName.get(Pool.class), "pool", new Modifier[0]);
        EntityDeclaration entityDeclaration = descriptor.entityDeclaration();
        TypeElement entityElement = entityDeclaration.targetType();
        NamingStrategy namingStrategy = descriptor.repositoryDeclaration().namingStrategy();
        String tableName = entityDeclaration.tableName();
        if (tableName.isEmpty()) {
            String entityName = entityDeclaration.targetType().getSimpleName().toString();
            tableName = NamingStrategies.resolveName(namingStrategy, entityName);
        }
        FieldDeclaration pkField = entityDeclaration.pkField();
        Optional<TypeMirror> pkConverter = pkField.converter();
        pkConverter.ifPresent(converter -> constructor.addStatement("var pkConverter = new $1T()", new Object[]{converter}));
        entityDeclaration.fieldsMap().entrySet().stream().filter(e -> ((FieldDeclaration)e.getValue()).converter().isPresent()).forEach(e -> constructor.addStatement("var $1LConverter = new $2T()", new Object[]{e.getKey(), ((FieldDeclaration)e.getValue()).converter().get()}));
        constructor.addCode("var mapperBuilder = $1T.<$2T, $3T>builder($4S, $3T::new)", new Object[]{ClassName.get(RowMapper.class), pkField.javaType(), entityElement, tableName});
        constructor.addCode("\n\t\t.pk($1S, $2T::get$3L, $2T::set$3L, $4L)", new Object[]{NamingStrategies.resolveName(namingStrategy, pkField.fieldName()), entityElement, this.toPropertyMethodSuffix(pkField.fieldName()), entityDeclaration.autoGenPK()});
        pkConverter.ifPresent(v -> constructor.addCode("\n\t\t.pkConverter(pkConverter::convertToDatabaseColumn, pkConverter::convertToEntityAttribute)", new Object[0]));
        for (Map.Entry<String, FieldDeclaration> fieldEntry : entityDeclaration.fieldsMap().entrySet()) {
            FieldDeclaration field = fieldEntry.getValue();
            if (field.converter().isEmpty()) {
                constructor.addCode("\n\t\t.addField($1S, $2T::get$3L, $2T::set$3L)", new Object[]{NamingStrategies.resolveName(namingStrategy, field.fieldName()), entityElement, this.toPropertyMethodSuffix(field.fieldName())});
                continue;
            }
            constructor.addCode("\n\t\t.addField($1S, $2T::get$3L, $2T::set$3L, $4LConverter::convertToDatabaseColumn, $4LConverter::convertToEntityAttribute)", new Object[]{NamingStrategies.resolveName(namingStrategy, field.fieldName()), entityElement, this.toPropertyMethodSuffix(field.fieldName()), fieldEntry.getKey()});
        }
        constructor.addCode(";\n", new Object[0]);
        constructor.addStatement("init(pool, ($1T<$2T, $3T>) mapperBuilder.build())", new Object[]{ClassName.get(RowMapperImpl.class), pkField.javaType(), entityElement});
        factory.addMethod(constructor.build());
    }

    private String toPropertyMethodSuffix(String fieldName) {
        return Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private boolean hasExtend(TypeMirror extendingType) {
        return !this.types.asElement(extendingType).toString().equals(CrudRepository.class.getTypeName());
    }

    private void addSuperclass(TypeSpec.Builder factory, RepositoryDescriptor descriptor) {
        if (this.hasExtend(descriptor.extendingType())) {
            factory.superclass(descriptor.extendingType());
            return;
        }
        Class supperClass = descriptor.repositoryDeclaration().driver() == Driver.POSTGRESQL ? AbstractCrudRepository.class : com.github.longdt.vertxorm.repository.mysql.AbstractCrudRepository.class;
        factory.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(supperClass), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)descriptor.entityDeclaration().pkField().javaType()), ClassName.get((TypeElement)descriptor.entityDeclaration().targetType())}));
    }
}

